/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import java.util.HashMap;
import java.util.Map;
import org.activiti.cloud.services.query.model.ApplicationEntity;
import org.activiti.cloud.services.query.model.ProcessDefinitionEntity;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.model.TaskVariableEntity;
import org.springframework.core.annotation.Order;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;

@Order(value=-2147483648)
public class QueryLinkRelationProvider
implements LinkRelationProvider {
    private Map<Class<?>, ResourceRelationDescriptor> resourceRelationDescriptors = new HashMap();

    public QueryLinkRelationProvider() {
        this.resourceRelationDescriptors.put(ProcessDefinitionEntity.class, new ResourceRelationDescriptor(this, "processDefinition", "processDefinitions"));
        this.resourceRelationDescriptors.put(ProcessInstanceEntity.class, new ResourceRelationDescriptor(this, "processInstance", "processInstances"));
        this.resourceRelationDescriptors.put(TaskEntity.class, new ResourceRelationDescriptor(this, "task", "tasks"));
        this.resourceRelationDescriptors.put(ProcessVariableEntity.class, new ResourceRelationDescriptor(this, "variable", "variables"));
        this.resourceRelationDescriptors.put(TaskVariableEntity.class, new ResourceRelationDescriptor(this, "variable", "variables"));
        this.resourceRelationDescriptors.put(ApplicationEntity.class, new ResourceRelationDescriptor(this, "application", "applications"));
    }

    public LinkRelation getItemResourceRelFor(Class<?> aClass) {
        return this.resourceRelationDescriptors.get(aClass).getItemResourceRel();
    }

    public LinkRelation getCollectionResourceRelFor(Class<?> aClass) {
        return this.resourceRelationDescriptors.get(aClass).getCollectionResourceRel();
    }

    public boolean supports(LinkRelationProvider.LookupContext delimiter) {
        return this.resourceRelationDescriptors.containsKey(delimiter.getType());
    }

    class ResourceRelationDescriptor {
        private LinkRelation itemResourceRel;
        private LinkRelation collectionResourceRel;

        public ResourceRelationDescriptor(QueryLinkRelationProvider this$0, String itemResourceRel, String collectionResourceRel) {
            this.itemResourceRel = LinkRelation.of((String)itemResourceRel);
            this.collectionResourceRel = LinkRelation.of((String)collectionResourceRel);
        }

        public LinkRelation getItemResourceRel() {
            return this.itemResourceRel;
        }

        public LinkRelation getCollectionResourceRel() {
            return this.collectionResourceRel;
        }
    }
}

