/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.CloudProcessDefinition;
import org.activiti.cloud.services.query.app.repository.ProcessDefinitionRepository;
import org.activiti.cloud.services.query.model.ProcessDefinitionEntity;
import org.activiti.cloud.services.query.model.QProcessCandidateStarterGroupEntity;
import org.activiti.cloud.services.query.model.QProcessCandidateStarterUserEntity;
import org.activiti.cloud.services.query.model.QProcessDefinitionEntity;
import org.activiti.cloud.services.query.rest.assembler.ProcessDefinitionRepresentationModelAssembler;
import org.activiti.cloud.services.security.ProcessDefinitionRestrictionService;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.ExposesResourceFor;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ExposesResourceFor(value=ProcessDefinitionEntity.class)
@RequestMapping(value={"/v1/process-definitions"}, produces={"application/hal+json", "application/json"})
public class ProcessDefinitionController {
    private static final String EVERYONE_GROUP = "*";
    private ProcessDefinitionRepository repository;
    private AlfrescoPagedModelAssembler<ProcessDefinitionEntity> pagedCollectionModelAssembler;
    private ProcessDefinitionRepresentationModelAssembler processDefinitionRepresentationModelAssembler;
    private ProcessDefinitionRestrictionService processDefinitionRestrictionService;
    private SecurityManager securityManager;

    public ProcessDefinitionController(ProcessDefinitionRepository repository, AlfrescoPagedModelAssembler<ProcessDefinitionEntity> pagedCollectionModelAssembler, ProcessDefinitionRepresentationModelAssembler processDefinitionRepresentationModelAssembler, ProcessDefinitionRestrictionService processDefinitionRestrictionService, SecurityManager securityManager) {
        this.repository = repository;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.processDefinitionRepresentationModelAssembler = processDefinitionRepresentationModelAssembler;
        this.processDefinitionRestrictionService = processDefinitionRestrictionService;
        this.securityManager = securityManager;
    }

    @GetMapping
    public PagedModel<EntityModel<CloudProcessDefinition>> findAllProcess(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessDefinitionEntity.class) Predicate predicate, Pageable pageable) {
        Predicate predicateRestricted = this.applyRestrictions(predicate);
        return this.pagedCollectionModelAssembler.toModel(pageable, this.repository.findAll(predicateRestricted, pageable), (RepresentationModelAssembler)this.processDefinitionRepresentationModelAssembler);
    }

    private Predicate applyRestrictions(Predicate predicate) {
        Predicate extendedPredicate = this.processDefinitionRestrictionService.restrictProcessDefinitionQuery(Optional.ofNullable(predicate).orElseGet(BooleanBuilder::new), SecurityPolicyAccess.READ);
        String userId = this.securityManager.getAuthenticatedUserId();
        BooleanExpression candidateStarterExpression = ((QProcessCandidateStarterUserEntity)QProcessDefinitionEntity.processDefinitionEntity.candidateStarterUsers.any()).userId.eq((Object)userId);
        List<String> groupIds = this.getCurrentUserGroupsIncludingEveryOneGroup();
        if (!groupIds.isEmpty()) {
            candidateStarterExpression = candidateStarterExpression.or((Predicate)((QProcessCandidateStarterGroupEntity)QProcessDefinitionEntity.processDefinitionEntity.candidateStarterGroups.any()).groupId.in(groupIds));
        }
        return candidateStarterExpression.and(extendedPredicate);
    }

    private List<String> getCurrentUserGroupsIncludingEveryOneGroup() {
        ArrayList<String> groups = new ArrayList<String>(this.securityManager.getAuthenticatedUserGroups());
        groups.add(EVERYONE_GROUP);
        return groups;
    }
}

