/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.helper;

import com.querydsl.core.types.Predicate;
import java.util.List;
import org.activiti.cloud.services.query.app.repository.ProcessInstanceRepository;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.rest.ProcessInstanceService;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceSearchRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class ProcessInstanceControllerHelper {
    private final ProcessInstanceRepository processInstanceRepository;
    private final ProcessInstanceService processInstanceService;

    public ProcessInstanceControllerHelper(ProcessInstanceRepository processInstanceRepository, ProcessInstanceService processInstanceService) {
        this.processInstanceRepository = processInstanceRepository;
        this.processInstanceService = processInstanceService;
    }

    public Page<ProcessInstanceEntity> findAllProcessInstances(Predicate predicate, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstances = this.processInstanceService.findAll(predicate, pageable);
        return this.mapAllSubprocesses(processInstances, pageable);
    }

    public Page<ProcessInstanceEntity> findAllProcessInstancesWithVariables(Predicate predicate, List<String> variableKeys, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstances = this.processInstanceService.findAllWithVariables(predicate, variableKeys, pageable);
        return this.mapAllSubprocesses(processInstances, pageable);
    }

    public ProcessInstanceEntity findById(String processInstanceId) {
        ProcessInstanceEntity processInstance = this.processInstanceService.findById(processInstanceId);
        return this.processInstanceRepository.mapSubprocesses(processInstance);
    }

    public Page<ProcessInstanceEntity> searchProcessInstances(ProcessInstanceSearchRequest searchRequest, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstances = this.processInstanceService.search(searchRequest, pageable);
        return this.mapAllSubprocesses(processInstances, pageable);
    }

    public Page<ProcessInstanceEntity> searchSubprocesses(String processInstanceId, Predicate predicate, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstanceSubprocesses = this.processInstanceService.subprocesses(processInstanceId, predicate, pageable);
        return this.mapAllSubprocesses(processInstanceSubprocesses, pageable);
    }

    public Page<ProcessInstanceEntity> mapAllSubprocesses(Page<ProcessInstanceEntity> processInstances, Pageable pageable) {
        return this.processInstanceRepository.mapSubprocesses(processInstances, pageable);
    }

    public Long countProcessInstances(ProcessInstanceSearchRequest searchRequest) {
        return this.processInstanceService.count(searchRequest);
    }
}

