/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.security;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import org.activiti.cloud.services.query.model.QProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QProcessVariableEntity;
import org.activiti.cloud.services.security.ProcessDefinitionKeyBasedRestrictionBuilder;
import org.activiti.cloud.services.security.ProcessInstanceVariableFilter;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesManager;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;

public class ProcessVariableRestrictionService {
    private SecurityPoliciesManager securityPoliciesManager;
    private ProcessInstanceVariableFilter processInstanceVariableFilter;
    private ProcessDefinitionKeyBasedRestrictionBuilder restrictionBuilder;

    public ProcessVariableRestrictionService(SecurityPoliciesManager securityPoliciesManager, ProcessInstanceVariableFilter processInstanceVariableFilter, ProcessDefinitionKeyBasedRestrictionBuilder restrictionBuilder) {
        this.securityPoliciesManager = securityPoliciesManager;
        this.processInstanceVariableFilter = processInstanceVariableFilter;
        this.restrictionBuilder = restrictionBuilder;
    }

    public Predicate restrictProcessInstanceVariableQuery(Predicate predicate, SecurityPolicyAccess securityPolicyAccess) {
        BooleanExpression varIsProcInstVar;
        if (!this.securityPoliciesManager.arePoliciesDefined()) {
            return predicate;
        }
        QProcessInstanceEntity processInstance = QProcessVariableEntity.processVariableEntity.processInstance;
        BooleanExpression extendedPredicate = varIsProcInstVar = processInstance.isNotNull();
        if (predicate != null) {
            extendedPredicate = varIsProcInstVar.and(predicate);
        }
        return this.restrictionBuilder.applyProcessDefinitionKeyFilter((Predicate)extendedPredicate, securityPolicyAccess, this.processInstanceVariableFilter);
    }
}

