/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.specification;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Collection;
import java.util.Map;
import org.activiti.cloud.services.query.app.repository.annotation.CountOverFullWindow;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.TaskCandidateGroupEntity_;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity_;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.model.TaskEntity_;
import org.activiti.cloud.services.query.model.TaskVariableEntity_;
import org.activiti.cloud.services.query.rest.filter.VariableFilter;
import org.activiti.cloud.services.query.rest.payload.TaskSearchRequest;
import org.activiti.cloud.services.query.rest.specification.SpecificationSupport;
import org.activiti.cloud.services.query.rest.specification.VariableValueFilterConditionImpl;
import org.springframework.util.CollectionUtils;

@CountOverFullWindow
public class TaskSpecification
extends SpecificationSupport<TaskEntity, TaskSearchRequest> {
    private final String userId;
    private final Collection<String> userGroups;

    private TaskSpecification(TaskSearchRequest searchRequest, String userId, Collection<String> userGroups) {
        super(searchRequest);
        this.userId = userId;
        this.userGroups = userGroups;
    }

    public static TaskSpecification unrestricted(TaskSearchRequest taskSearchRequest) {
        return new TaskSpecification(taskSearchRequest, null, null);
    }

    public static TaskSpecification restricted(TaskSearchRequest taskSearchRequest, String userId, Collection<String> userGroups) {
        return new TaskSpecification(taskSearchRequest, userId, userGroups);
    }

    @Override
    public Predicate toPredicate(Root<TaskEntity> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        this.reset();
        this.applyUserRestrictionFilter(root, criteriaBuilder);
        this.applyRootTasksFilter(root, criteriaBuilder);
        this.applyIdFilter(root);
        this.applyParentIdFilter(root);
        this.applyProcessInstanceIdFilter(root);
        this.applyStandaloneFilter(root, criteriaBuilder);
        this.applyNameFilter(root, criteriaBuilder);
        this.applyDescriptionFilter(root, criteriaBuilder);
        this.applyProcessDefinitionNameFilter(root, criteriaBuilder);
        this.applyPriorityFilter(root);
        this.applyStatusFilter(root);
        this.applyCompletedByFilter(root);
        this.applyAssigneeFilter(root);
        this.applyCreatedDateFilters(root, criteriaBuilder);
        this.applyLastModifiedDateFilters(root, criteriaBuilder);
        this.applyLastClaimedDateFilters(root, criteriaBuilder);
        this.applyCompletedDateFilters(root, criteriaBuilder);
        this.applyDueDateFilters(root, criteriaBuilder);
        this.applyCandidateUserFilter(root);
        this.applyCandidateGroupFilter(root);
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).taskVariableFilters())) {
            SetJoin tvRoot = root.join(TaskEntity_.variables, JoinType.LEFT);
            this.filterConditions.addAll(((TaskSearchRequest)this.searchRequest).taskVariableFilters().stream().map(filter -> new VariableValueFilterConditionImpl(tvRoot, Map.of(tvRoot.get(TaskVariableEntity_.name), filter.name()), (Class)this.javaTypeMapping.get((Object)filter.type()), (VariableFilter)filter, criteriaBuilder)).toList());
        }
        return super.toPredicate(root, query, criteriaBuilder);
    }

    @Override
    protected SingularAttribute<TaskEntity, String> getIdAttribute() {
        return TaskEntity_.id;
    }

    @Override
    protected SetAttribute<TaskEntity, ProcessVariableEntity> getProcessVariablesAttribute() {
        return TaskEntity_.processVariables;
    }

    private void applyParentIdFilter(Root<TaskEntity> root) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).parentId())) {
            this.predicates.add(root.get(TaskEntity_.parentTaskId).in(((TaskSearchRequest)this.searchRequest).parentId()));
        }
    }

    private void applyProcessInstanceIdFilter(Root<TaskEntity> root) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).processInstanceId())) {
            this.predicates.add(root.get(TaskEntity_.processInstanceId).in(((TaskSearchRequest)this.searchRequest).processInstanceId()));
        }
    }

    private void applyProcessDefinitionNameFilter(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).processDefinitionName())) {
            this.addLikeFilters(this.predicates, ((TaskSearchRequest)this.searchRequest).processDefinitionName(), root, criteriaBuilder, TaskEntity_.processDefinitionName);
        }
    }

    private void applyCandidateGroupFilter(Root<TaskEntity> root) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).candidateGroupId())) {
            this.predicates.add(root.join(TaskEntity_.taskCandidateGroups).get(TaskCandidateGroupEntity_.groupId).in(((TaskSearchRequest)this.searchRequest).candidateGroupId()));
        }
    }

    private void applyCandidateUserFilter(Root<TaskEntity> root) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).candidateUserId())) {
            this.predicates.add(root.join(TaskEntity_.taskCandidateUsers).get(TaskCandidateUserEntity_.userId).in(((TaskSearchRequest)this.searchRequest).candidateUserId()));
        }
    }

    private void applyDueDateFilters(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((TaskSearchRequest)this.searchRequest).dueDateFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(TaskEntity_.dueDate), (Comparable)((TaskSearchRequest)this.searchRequest).dueDateFrom()));
        }
        if (((TaskSearchRequest)this.searchRequest).dueDateTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(TaskEntity_.dueDate), (Comparable)((TaskSearchRequest)this.searchRequest).dueDateTo()));
        }
    }

    private void applyCompletedDateFilters(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((TaskSearchRequest)this.searchRequest).completedFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(TaskEntity_.completedDate), (Comparable)((TaskSearchRequest)this.searchRequest).completedFrom()));
        }
        if (((TaskSearchRequest)this.searchRequest).completedTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(TaskEntity_.completedDate), (Comparable)((TaskSearchRequest)this.searchRequest).completedTo()));
        }
    }

    private void applyLastClaimedDateFilters(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((TaskSearchRequest)this.searchRequest).lastClaimedFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(TaskEntity_.claimedDate), (Comparable)((TaskSearchRequest)this.searchRequest).lastClaimedFrom()));
        }
        if (((TaskSearchRequest)this.searchRequest).lastClaimedTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(TaskEntity_.claimedDate), (Comparable)((TaskSearchRequest)this.searchRequest).lastClaimedTo()));
        }
    }

    private void applyLastModifiedDateFilters(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((TaskSearchRequest)this.searchRequest).lastModifiedFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(TaskEntity_.lastModified), (Comparable)((TaskSearchRequest)this.searchRequest).lastModifiedFrom()));
        }
        if (((TaskSearchRequest)this.searchRequest).lastModifiedTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(TaskEntity_.lastModified), (Comparable)((TaskSearchRequest)this.searchRequest).lastModifiedTo()));
        }
    }

    private void applyCreatedDateFilters(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((TaskSearchRequest)this.searchRequest).createdFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(TaskEntity_.createdDate), (Comparable)((TaskSearchRequest)this.searchRequest).createdFrom()));
        }
        if (((TaskSearchRequest)this.searchRequest).createdTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(TaskEntity_.createdDate), (Comparable)((TaskSearchRequest)this.searchRequest).createdTo()));
        }
    }

    private void applyAssigneeFilter(Root<TaskEntity> root) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).assignee())) {
            this.predicates.add(root.get(TaskEntity_.assignee).in(((TaskSearchRequest)this.searchRequest).assignee()));
        }
    }

    private void applyCompletedByFilter(Root<TaskEntity> root) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).completedBy())) {
            this.predicates.add(root.get(TaskEntity_.completedBy).in(((TaskSearchRequest)this.searchRequest).completedBy()));
        }
    }

    private void applyStatusFilter(Root<TaskEntity> root) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).status())) {
            this.predicates.add(root.get(TaskEntity_.status).in(((TaskSearchRequest)this.searchRequest).status()));
        }
    }

    private void applyPriorityFilter(Root<TaskEntity> root) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).priority())) {
            this.predicates.add(root.get(TaskEntity_.priority).in(((TaskSearchRequest)this.searchRequest).priority()));
        }
    }

    private void applyDescriptionFilter(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).description())) {
            this.addLikeFilters(this.predicates, ((TaskSearchRequest)this.searchRequest).description(), root, criteriaBuilder, TaskEntity_.description);
        }
    }

    private void applyNameFilter(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (!CollectionUtils.isEmpty(((TaskSearchRequest)this.searchRequest).name())) {
            this.addLikeFilters(this.predicates, ((TaskSearchRequest)this.searchRequest).name(), root, criteriaBuilder, TaskEntity_.name);
        }
    }

    private void applyStandaloneFilter(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((TaskSearchRequest)this.searchRequest).onlyStandalone()) {
            this.predicates.add(criteriaBuilder.isNull((Expression)root.get(TaskEntity_.processInstanceId)));
        }
    }

    private void applyRootTasksFilter(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((TaskSearchRequest)this.searchRequest).onlyRoot()) {
            this.predicates.add(criteriaBuilder.isNull((Expression)root.get(TaskEntity_.parentTaskId)));
        }
    }

    private void applyUserRestrictionFilter(Root<TaskEntity> root, CriteriaBuilder criteriaBuilder) {
        if (this.userId != null) {
            this.predicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.equal((Expression)root.get(TaskEntity_.assignee), (Object)this.userId), criteriaBuilder.equal((Expression)root.get(TaskEntity_.owner), (Object)this.userId), criteriaBuilder.and((Expression)criteriaBuilder.isNull((Expression)root.get(TaskEntity_.assignee)), (Expression)criteriaBuilder.or(new Predicate[]{criteriaBuilder.equal((Expression)root.join(TaskEntity_.taskCandidateUsers, JoinType.LEFT).get(TaskCandidateUserEntity_.userId), (Object)this.userId), root.join(TaskEntity_.taskCandidateGroups, JoinType.LEFT).get(TaskCandidateGroupEntity_.groupId).in(this.userGroups), criteriaBuilder.and((Expression)criteriaBuilder.isEmpty(root.get((PluralAttribute)TaskEntity_.taskCandidateUsers)), (Expression)criteriaBuilder.isEmpty(root.get((PluralAttribute)TaskEntity_.taskCandidateGroups)))}))}));
        }
    }
}

