/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.specification;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import org.activiti.cloud.services.query.app.repository.annotation.CountOverFullWindow;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity_;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity_;
import org.activiti.cloud.services.query.model.TaskEntity_;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceSearchRequest;
import org.activiti.cloud.services.query.rest.specification.SpecificationSupport;
import org.springframework.util.CollectionUtils;

@CountOverFullWindow
public class ProcessInstanceSpecification
extends SpecificationSupport<ProcessInstanceEntity, ProcessInstanceSearchRequest> {
    private final String userId;

    private ProcessInstanceSpecification(ProcessInstanceSearchRequest searchRequest, String userId) {
        super(searchRequest);
        this.userId = userId;
    }

    public static ProcessInstanceSpecification unrestricted(ProcessInstanceSearchRequest searchRequest) {
        return new ProcessInstanceSpecification(searchRequest, null);
    }

    public static ProcessInstanceSpecification restricted(ProcessInstanceSearchRequest searchRequest, String userId) {
        return new ProcessInstanceSpecification(searchRequest, userId);
    }

    @Override
    public Predicate toPredicate(Root<ProcessInstanceEntity> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        this.reset();
        this.applyUserRestrictionFilter(root, criteriaBuilder);
        this.applyIdFilter(root);
        this.applyParentIdFilter(root);
        this.applyNameFilter(root, criteriaBuilder);
        this.applyProcessDefinitionNameFilter(root);
        this.applyInitiatorFilter(root);
        this.applyAppVersionFilter(root);
        this.applyStatusFilter(root);
        this.applyLastModifiedDateFilters(root, criteriaBuilder);
        this.applyStartFilters(root, criteriaBuilder);
        this.applyCompletedFilters(root, criteriaBuilder);
        this.applySuspendedFilters(root, criteriaBuilder);
        this.applyIncludeSubprocesses(root);
        return super.toPredicate(root, query, criteriaBuilder);
    }

    private void applyIncludeSubprocesses(Root<ProcessInstanceEntity> root) {
        if (!((ProcessInstanceSearchRequest)this.searchRequest).includeSubprocesses().booleanValue()) {
            this.predicates.add(root.get(ProcessInstanceEntity_.parentId).isNull());
        }
    }

    @Override
    protected SingularAttribute<ProcessInstanceEntity, String> getIdAttribute() {
        return ProcessInstanceEntity_.id;
    }

    @Override
    protected SetAttribute<ProcessInstanceEntity, ProcessVariableEntity> getProcessVariablesAttribute() {
        return ProcessInstanceEntity_.variables;
    }

    private void applyParentIdFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).parentId())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.parentId).in(((ProcessInstanceSearchRequest)this.searchRequest).parentId()));
        }
    }

    private void applyNameFilter(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).name())) {
            this.addLikeFilters(this.predicates, ((ProcessInstanceSearchRequest)this.searchRequest).name(), root, criteriaBuilder, ProcessInstanceEntity_.name);
        }
    }

    private void applyProcessDefinitionNameFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).processDefinitionName())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.processDefinitionName).in(((ProcessInstanceSearchRequest)this.searchRequest).processDefinitionName()));
        }
    }

    private void applyInitiatorFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).initiator())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.initiator).in(((ProcessInstanceSearchRequest)this.searchRequest).initiator()));
        }
    }

    private void applyAppVersionFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).appVersion())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.appVersion).in(((ProcessInstanceSearchRequest)this.searchRequest).appVersion()));
        }
    }

    private void applyStatusFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).status())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.status).in(((ProcessInstanceSearchRequest)this.searchRequest).status()));
        }
    }

    private void applyLastModifiedDateFilters(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((ProcessInstanceSearchRequest)this.searchRequest).lastModifiedFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(ProcessInstanceEntity_.lastModified), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).lastModifiedFrom()));
        }
        if (((ProcessInstanceSearchRequest)this.searchRequest).lastModifiedTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(ProcessInstanceEntity_.lastModified), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).lastModifiedTo()));
        }
    }

    private void applyStartFilters(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((ProcessInstanceSearchRequest)this.searchRequest).startFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(ProcessInstanceEntity_.startDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).startFrom()));
        }
        if (((ProcessInstanceSearchRequest)this.searchRequest).startTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(ProcessInstanceEntity_.startDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).startTo()));
        }
    }

    private void applyCompletedFilters(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((ProcessInstanceSearchRequest)this.searchRequest).completedFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(ProcessInstanceEntity_.completedDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).completedFrom()));
        }
        if (((ProcessInstanceSearchRequest)this.searchRequest).completedTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(ProcessInstanceEntity_.completedDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).completedTo()));
        }
    }

    private void applySuspendedFilters(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((ProcessInstanceSearchRequest)this.searchRequest).suspendedFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(ProcessInstanceEntity_.suspendedDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).suspendedFrom()));
        }
        if (((ProcessInstanceSearchRequest)this.searchRequest).suspendedTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(ProcessInstanceEntity_.suspendedDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).suspendedTo()));
        }
    }

    private void applyUserRestrictionFilter(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (this.userId != null) {
            this.predicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.equal((Expression)root.get(ProcessInstanceEntity_.initiator), (Object)this.userId), criteriaBuilder.equal((Expression)root.join(ProcessInstanceEntity_.tasks, JoinType.LEFT).get(TaskEntity_.assignee), (Object)this.userId), criteriaBuilder.equal((Expression)root.join(ProcessInstanceEntity_.tasks, JoinType.LEFT).join(TaskEntity_.taskCandidateUsers, JoinType.LEFT).get(TaskCandidateUserEntity_.userId), (Object)this.userId)}));
        }
    }
}

