/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import io.swagger.v3.oas.annotations.Parameter;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.CloudServiceTask;
import org.activiti.cloud.services.query.app.repository.EntityFinder;
import org.activiti.cloud.services.query.app.repository.ServiceTaskRepository;
import org.activiti.cloud.services.query.model.QServiceTaskEntity;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;
import org.activiti.cloud.services.query.rest.assembler.ServiceTaskRepresentationModelAssembler;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/service-tasks"}, produces={"application/hal+json", "application/json"})
public class ServiceTaskAdminController {
    private final ServiceTaskRepository serviceTaskRepository;
    private final ServiceTaskRepresentationModelAssembler representationModelAssembler;
    private final AlfrescoPagedModelAssembler<ServiceTaskEntity> pagedCollectionModelAssembler;
    private final EntityFinder entityFinder;

    public ServiceTaskAdminController(ServiceTaskRepository serviceTaskRepository, ServiceTaskRepresentationModelAssembler representationModelAssembler, AlfrescoPagedModelAssembler<ServiceTaskEntity> pagedCollectionModelAssembler, EntityFinder entityFinder) {
        this.serviceTaskRepository = serviceTaskRepository;
        this.representationModelAssembler = representationModelAssembler;
        this.entityFinder = entityFinder;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
    }

    @RequestMapping(method={RequestMethod.GET})
    public PagedModel<EntityModel<CloudServiceTask>> findAllServiceTasks(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ServiceTaskEntity.class) Predicate predicate, Pageable pageable) {
        return this.pagedCollectionModelAssembler.toModel(pageable, this.serviceTaskRepository.findAll(predicate, pageable), (RepresentationModelAssembler)this.representationModelAssembler);
    }

    @RequestMapping(value={"/{serviceTaskId}"}, method={RequestMethod.GET})
    public EntityModel<CloudServiceTask> findByIdServiceTaskAdmin(@PathVariable String serviceTaskId) {
        BooleanExpression filter = QServiceTaskEntity.serviceTaskEntity.id.eq((Object)serviceTaskId);
        ServiceTaskEntity entity = (ServiceTaskEntity)this.entityFinder.findOne((QuerydslPredicateExecutor)this.serviceTaskRepository, (Predicate)filter, "Unable to find service task entity for the given id:'" + serviceTaskId + "'");
        return this.representationModelAssembler.toModel(entity);
    }
}

