/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.security;

import com.introproventures.graphql.jpa.query.schema.RestrictedKeysProvider;
import com.introproventures.graphql.jpa.query.schema.impl.EntityIntrospector;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.jpa.impl.JPAQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.activiti.cloud.services.query.model.ApplicationEntity;
import org.activiti.cloud.services.query.model.ProcessDefinitionEntity;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessModelEntity;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.QProcessDefinitionEntity;
import org.activiti.cloud.services.query.model.QProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QProcessVariableEntity;
import org.activiti.cloud.services.query.model.QTaskEntity;
import org.activiti.cloud.services.query.model.QTaskVariableEntity;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.model.TaskVariableEntity;
import org.activiti.cloud.services.security.ProcessDefinitionRestrictionService;
import org.activiti.cloud.services.security.ProcessInstanceRestrictionService;
import org.activiti.cloud.services.security.ProcessVariableRestrictionService;
import org.activiti.cloud.services.security.TaskLookupRestrictionService;
import org.activiti.cloud.services.security.TaskVariableLookupRestrictionService;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ActivitiRestrictedKeysProvider
implements RestrictedKeysProvider {
    private static final Logger log = LoggerFactory.getLogger(ActivitiRestrictedKeysProvider.class);
    private final ProcessDefinitionRestrictionService processDefinitionRestrictionService;
    private final ProcessInstanceRestrictionService processInstanceRestrictionService;
    private final ProcessVariableRestrictionService processVariableRestrictionService;
    private final TaskLookupRestrictionService taskLookupRestrictionService;
    private final TaskVariableLookupRestrictionService taskVariableLookupRestrictionService;
    private final EntityManager entityManager;
    private final List<String> unrestrictedRoles;
    private String rolePrefix = "ROLE_";

    public ActivitiRestrictedKeysProvider(EntityManagerFactory entityManagerFactory, ProcessDefinitionRestrictionService processDefinitionRestrictionService, ProcessInstanceRestrictionService processInstanceRestrictionService, ProcessVariableRestrictionService processVariableRestrictionService, TaskLookupRestrictionService taskLookupRestrictionService, TaskVariableLookupRestrictionService taskVariableLookupRestrictionService, List<String> unrestrictedRoles) {
        this.processDefinitionRestrictionService = processDefinitionRestrictionService;
        this.entityManager = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)entityManagerFactory);
        this.processInstanceRestrictionService = processInstanceRestrictionService;
        this.processVariableRestrictionService = processVariableRestrictionService;
        this.taskLookupRestrictionService = taskLookupRestrictionService;
        this.taskVariableLookupRestrictionService = taskVariableLookupRestrictionService;
        this.unrestrictedRoles = unrestrictedRoles;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public List<String> getUnrestrictedRoles() {
        return this.unrestrictedRoles;
    }

    public Optional<List<Object>> apply(EntityIntrospector.EntityIntrospectionResult entityDescriptor) {
        Class entity = entityDescriptor.getEntity();
        if (this.isAnonymousUser()) {
            throw new AccessDeniedException("Access denied");
        }
        return this.ifUnrestrictedByUserRoles().or(new ProcessDefinitionRestrictedKeysSupplier(entity)).or(new ProcessInstanceRestrictedKeysSupplier(entity)).or(new TaskRestrictedKeysSupplier(entity)).or(new ProcessVariablesRestrictedKeysSupplier(entity)).or(new TaskVariableRestrictedKeysSupplier(entity)).or(new ProcessModelKeysSupplier(this, entity)).or(new ApplicationKeysSupplier(this, entity)).or(new ServiceTaskKeysSupplier(this, entity));
    }

    boolean isAnonymousUser() {
        return Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).map(AnonymousAuthenticationToken.class::isInstance).orElse(false);
    }

    Optional<List<Object>> ifUnrestrictedByUserRoles() {
        return Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).filter(Authentication::isAuthenticated).map(Authentication::getAuthorities).map(authorities -> authorities.stream().map(GrantedAuthority::getAuthority).filter(value -> value.startsWith(this.rolePrefix)).map(value -> value.replaceFirst("^".concat(this.rolePrefix), "")).anyMatch(this.unrestrictedRoles::contains)).filter(Boolean.TRUE::equals).map(ifUnrestricted -> List.of("*"));
    }

    class ProcessDefinitionRestrictedKeysSupplier
    extends RestrictedKeysSupplier<ProcessDefinitionEntity> {
        ProcessDefinitionRestrictedKeysSupplier(Class<?> entityClass) {
            super(entityClass);
        }

        @Override
        List<Object> getKeys(Class<?> entityClass) {
            com.querydsl.core.types.Predicate predicate = ActivitiRestrictedKeysProvider.this.processDefinitionRestrictionService.restrictProcessDefinitionQuery((com.querydsl.core.types.Predicate)new BooleanBuilder(), SecurityPolicyAccess.READ);
            QProcessDefinitionEntity entity = QProcessDefinitionEntity.processDefinitionEntity;
            JPAQuery query = (JPAQuery)((JPAQuery)new JPAQuery(ActivitiRestrictedKeysProvider.this.entityManager).from((EntityPath)entity)).select((Expression)entity.id).where(predicate);
            return query.fetch().stream().map(Object.class::cast).toList();
        }
    }

    class ProcessInstanceRestrictedKeysSupplier
    extends RestrictedKeysSupplier<ProcessInstanceEntity> {
        ProcessInstanceRestrictedKeysSupplier(Class<?> entityClass) {
            super(entityClass);
        }

        @Override
        List<Object> getKeys(Class<?> entityClass) {
            com.querydsl.core.types.Predicate predicate = ActivitiRestrictedKeysProvider.this.processInstanceRestrictionService.restrictProcessInstanceQuery((com.querydsl.core.types.Predicate)new BooleanBuilder(), SecurityPolicyAccess.READ);
            QProcessInstanceEntity entity = QProcessInstanceEntity.processInstanceEntity;
            JPAQuery query = (JPAQuery)((JPAQuery)new JPAQuery(ActivitiRestrictedKeysProvider.this.entityManager).from((EntityPath)entity)).select((Expression)entity.id).where(predicate);
            return query.fetch().stream().map(Object.class::cast).toList();
        }
    }

    class TaskRestrictedKeysSupplier
    extends RestrictedKeysSupplier<TaskEntity> {
        TaskRestrictedKeysSupplier(Class<?> entityClass) {
            super(entityClass);
        }

        @Override
        List<Object> getKeys(Class<?> entityClass) {
            com.querydsl.core.types.Predicate predicate = ActivitiRestrictedKeysProvider.this.taskLookupRestrictionService.restrictToInvolvedUsersQuery((com.querydsl.core.types.Predicate)new BooleanBuilder());
            QTaskEntity taskEntity = QTaskEntity.taskEntity;
            QProcessInstanceEntity processInstanceEntity = QProcessInstanceEntity.processInstanceEntity;
            JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)new JPAQuery(ActivitiRestrictedKeysProvider.this.entityManager).from((EntityPath)taskEntity)).leftJoin((EntityPath)processInstanceEntity)).on((com.querydsl.core.types.Predicate)processInstanceEntity.id.eq((Expression)taskEntity.processInstanceId))).select((Expression)taskEntity.id).where(predicate);
            return query.fetch().stream().map(Object.class::cast).toList();
        }
    }

    class ProcessVariablesRestrictedKeysSupplier
    extends RestrictedKeysSupplier<ProcessVariableEntity> {
        ProcessVariablesRestrictedKeysSupplier(Class<?> entityClass) {
            super(entityClass);
        }

        @Override
        List<Object> getKeys(Class<?> entityClass) {
            com.querydsl.core.types.Predicate predicate = ActivitiRestrictedKeysProvider.this.processVariableRestrictionService.restrictProcessInstanceVariableQuery((com.querydsl.core.types.Predicate)new BooleanBuilder(), SecurityPolicyAccess.READ);
            QProcessVariableEntity entity = QProcessVariableEntity.processVariableEntity;
            JPAQuery query = (JPAQuery)((JPAQuery)new JPAQuery(ActivitiRestrictedKeysProvider.this.entityManager).from((EntityPath)entity)).select((Expression)entity.id).where(predicate);
            return query.fetch().stream().map(Object.class::cast).toList();
        }
    }

    class TaskVariableRestrictedKeysSupplier
    extends RestrictedKeysSupplier<TaskVariableEntity> {
        TaskVariableRestrictedKeysSupplier(Class<?> entityClass) {
            super(entityClass);
        }

        @Override
        List<Object> getKeys(Class<?> entityClass) {
            com.querydsl.core.types.Predicate predicate = ActivitiRestrictedKeysProvider.this.taskVariableLookupRestrictionService.restrictTaskVariableQuery((com.querydsl.core.types.Predicate)new BooleanBuilder());
            QTaskVariableEntity entity = QTaskVariableEntity.taskVariableEntity;
            JPAQuery query = (JPAQuery)((JPAQuery)new JPAQuery(ActivitiRestrictedKeysProvider.this.entityManager).from((EntityPath)entity)).select((Expression)entity.id).where(predicate);
            return query.fetch().stream().map(Object.class::cast).toList();
        }
    }

    class ProcessModelKeysSupplier
    extends RestrictedKeysSupplier<ProcessModelEntity> {
        ProcessModelKeysSupplier(ActivitiRestrictedKeysProvider this$0, Class<?> entityClass) {
            super(entityClass);
        }

        @Override
        List<Object> getKeys(Class<?> entityClass) {
            return List.of("*");
        }
    }

    class ApplicationKeysSupplier
    extends RestrictedKeysSupplier<ApplicationEntity> {
        ApplicationKeysSupplier(ActivitiRestrictedKeysProvider this$0, Class<?> entityClass) {
            super(entityClass);
        }

        @Override
        List<Object> getKeys(Class<?> entityClass) {
            return List.of("*");
        }
    }

    class ServiceTaskKeysSupplier
    extends RestrictedKeysSupplier<ServiceTaskEntity> {
        ServiceTaskKeysSupplier(ActivitiRestrictedKeysProvider this$0, Class<?> entityClass) {
            super(entityClass);
        }

        @Override
        List<Object> getKeys(Class<?> entityClass) {
            return List.of("*");
        }
    }

    static abstract class RestrictedKeysSupplier<T>
    implements Supplier<Optional<List<Object>>> {
        private final Class<?> entityClass;
        private final Class<T> genericType;

        RestrictedKeysSupplier(Class<?> entityClass) {
            this.entityClass = entityClass;
            this.genericType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }

        @Override
        public Optional<List<Object>> get() {
            return Optional.of(this.entityClass).filter(this::isInstance).map(this::getKeys).filter(Predicate.not(Collection::isEmpty));
        }

        boolean isInstance(Class<?> entityClass) {
            return this.genericType.equals(this.entityClass);
        }

        abstract List<Object> getKeys(Class<?> var1);
    }
}

