/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Optional;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.model.shared.QueryCloudVariableInstance;
import org.activiti.cloud.services.query.app.repository.VariableRepository;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.QProcessVariableEntity;
import org.activiti.cloud.services.query.rest.assembler.QueryCloudVariableInstanceRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/process-instances/{processInstanceId}/variables"}, produces={"application/hal+json", "application/json"})
public class ProcessInstanceVariableAdminController {
    private final AlfrescoPagedModelAssembler<ProcessVariableEntity> pagedVariablesCollectionModelAssembler;
    private final VariableRepository variableRepository;
    private final QueryCloudVariableInstanceRepresentationModelAssembler variableRepresentationModelAssembler;

    @Autowired
    public ProcessInstanceVariableAdminController(VariableRepository variableRepository, QueryCloudVariableInstanceRepresentationModelAssembler variableRepresentationModelAssembler, AlfrescoPagedModelAssembler<ProcessVariableEntity> pagedVariablesCollectionModelAssembler) {
        this.variableRepository = variableRepository;
        this.variableRepresentationModelAssembler = variableRepresentationModelAssembler;
        this.pagedVariablesCollectionModelAssembler = pagedVariablesCollectionModelAssembler;
    }

    @RequestMapping(method={RequestMethod.GET})
    public PagedModel<EntityModel<QueryCloudVariableInstance>> getVariablesProcessAdmin(@PathVariable String processInstanceId, @Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessVariableEntity.class) Predicate predicate, Pageable pageable) {
        predicate = Optional.ofNullable(predicate).orElseGet(BooleanBuilder::new);
        QProcessVariableEntity variable = QProcessVariableEntity.processVariableEntity;
        BooleanExpression expression = variable.processInstanceId.eq((Object)processInstanceId);
        if (predicate != null) {
            expression = expression.and(predicate);
        }
        BooleanExpression extendedPredicate = expression;
        return this.pagedVariablesCollectionModelAssembler.toModel(pageable, this.variableRepository.findAll((Predicate)extendedPredicate, pageable), (RepresentationModelAssembler)this.variableRepresentationModelAssembler);
    }
}

