/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.cloud.api.task.model.QueryCloudTask;
import org.activiti.cloud.services.query.model.QTaskEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.rest.TaskControllerHelper;

public class TaskPermissionsHelper {
    private final SecurityManager securityManager;
    private final TaskControllerHelper taskControllerHelper;

    public TaskPermissionsHelper(SecurityManager securityManager, TaskControllerHelper taskControllerHelper) {
        this.securityManager = securityManager;
        this.taskControllerHelper = taskControllerHelper;
    }

    public void setCurrentUserTaskPermissions(TaskEntity task) {
        String userId = this.securityManager.getAuthenticatedUserId();
        if (userId != null) {
            List userGroups = this.securityManager.getAuthenticatedUserGroups();
            ArrayList<QueryCloudTask.TaskPermissions> permissions = new ArrayList<QueryCloudTask.TaskPermissions>();
            if (!this.canUserViewTask(task)) {
                return;
            }
            permissions.add(QueryCloudTask.TaskPermissions.VIEW);
            if (this.canUserClaimTask(task, userId, userGroups)) {
                permissions.add(QueryCloudTask.TaskPermissions.CLAIM);
            }
            if (this.canUserReleaseTask(task, userId)) {
                permissions.add(QueryCloudTask.TaskPermissions.RELEASE);
            }
            if (this.canUserUpdateTask(task, userId)) {
                permissions.add(QueryCloudTask.TaskPermissions.UPDATE);
            }
            task.setPermissions(permissions);
        }
    }

    private boolean canUserViewTask(TaskEntity task) {
        return this.taskControllerHelper.canUserViewTask((com.querydsl.core.types.Predicate)QTaskEntity.taskEntity.id.eq((Object)task.getId()));
    }

    private boolean canUserClaimTask(TaskEntity task, String userId, List<String> userGroups) {
        return !this.isTaskAssigned(task) && this.isUserCandidate(task, userId, userGroups);
    }

    private boolean canUserReleaseTask(TaskEntity task, String userId) {
        boolean taskHasCandidatesUser = task.getCandidateUsers() != null && !task.getCandidateUsers().isEmpty();
        boolean taskHasCandidateGroups = task.getCandidateGroups() != null && !task.getCandidateGroups().isEmpty();
        return this.isUserAssignee(task, userId) && (taskHasCandidatesUser || taskHasCandidateGroups);
    }

    private boolean canUserUpdateTask(TaskEntity task, String userId) {
        boolean isUserOwner = task.getOwner() != null && task.getOwner().equals(userId);
        return this.isUserAssignee(task, userId) || isUserOwner;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isUserCandidate(TaskEntity task, String userId, List<String> userGroups) {
        v0 = isCandidateUser = task.getCandidateUsers() != null && task.getCandidateUsers().contains(userId) != false;
        if (task.getCandidateGroups() == null) ** GOTO lbl-1000
        if (task.getCandidateGroups().stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(userGroups))) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isCandidateGroup = v1;
        return isCandidateUser != false || isCandidateGroup != false;
    }

    private boolean isUserAssignee(TaskEntity task, String userId) {
        return this.isTaskAssigned(task) && task.getAssignee().equals(userId);
    }

    private boolean isTaskAssigned(TaskEntity task) {
        return task.getAssignee() != null;
    }
}

