/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.helper;

import com.querydsl.core.types.Predicate;
import java.util.List;
import org.activiti.cloud.services.query.app.repository.ProcessInstanceRepository;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.rest.ProcessInstanceAdminService;
import org.activiti.cloud.services.query.rest.helper.ProcessInstanceControllerHelper;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceSearchRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class ProcessInstanceAdminControllerHelper {
    private final ProcessInstanceRepository processInstanceRepository;
    private final ProcessInstanceAdminService processInstanceAdminService;
    private final ProcessInstanceControllerHelper processInstanceControllerHelper;

    public ProcessInstanceAdminControllerHelper(ProcessInstanceRepository processInstanceRepository, ProcessInstanceAdminService processInstanceAdminService, ProcessInstanceControllerHelper processInstanceControllerHelper) {
        this.processInstanceRepository = processInstanceRepository;
        this.processInstanceAdminService = processInstanceAdminService;
        this.processInstanceControllerHelper = processInstanceControllerHelper;
    }

    public Page<ProcessInstanceEntity> findAllProcessInstanceAdmin(Predicate predicate, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstances = this.processInstanceAdminService.findAll(predicate, pageable);
        return this.processInstanceControllerHelper.mapAllSubprocesses(processInstances, pageable);
    }

    public Page<ProcessInstanceEntity> findAllProcessInstanceAdminWithVariables(Predicate predicate, List<String> variableKeys, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstances = this.processInstanceAdminService.findAllWithVariables(predicate, variableKeys, pageable);
        return this.processInstanceControllerHelper.mapAllSubprocesses(processInstances, pageable);
    }

    public ProcessInstanceEntity findByIdProcessAdmin(String processInstanceId) {
        ProcessInstanceEntity processInstance = this.processInstanceAdminService.findById(processInstanceId);
        return this.processInstanceRepository.mapSubprocesses(processInstance);
    }

    public Page<ProcessInstanceEntity> searchProcessInstances(ProcessInstanceSearchRequest searchRequest, Pageable pageable) {
        Page<ProcessInstanceEntity> processInstances = this.processInstanceAdminService.search(searchRequest, pageable);
        return this.processInstanceControllerHelper.mapAllSubprocesses(processInstances, pageable);
    }

    public Page<ProcessInstanceEntity> searchSubprocesses(String processInstanceId, Predicate predicate, Pageable pageable) {
        return this.processInstanceControllerHelper.searchSubprocesses(processInstanceId, predicate, pageable);
    }

    public Page<ProcessInstanceEntity> searchLinkedProcesses(String linkedProcessInstanceId, Pageable pageable) {
        return this.processInstanceControllerHelper.searchLinkedProcesses(linkedProcessInstanceId, pageable);
    }
}

