/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import jakarta.persistence.EntityNotFoundException;
import org.activiti.cloud.api.process.model.CloudIntegrationContext;
import org.activiti.cloud.services.query.app.repository.IntegrationContextRepository;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.activiti.cloud.services.query.rest.assembler.IntegrationContextRepresentationModelAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/integration-contexts"}, produces={"application/hal+json", "application/json"})
public class IntegrationContextAdminController {
    private final IntegrationContextRepository repository;
    private final IntegrationContextRepresentationModelAssembler representationModelAssembler;

    public IntegrationContextAdminController(IntegrationContextRepository repository, IntegrationContextRepresentationModelAssembler representationModelAssembler) {
        this.repository = repository;
        this.representationModelAssembler = representationModelAssembler;
    }

    @RequestMapping(value={"/{integrationContextId}"}, method={RequestMethod.GET})
    public EntityModel<CloudIntegrationContext> findById(@PathVariable String integrationContextId) {
        IntegrationContextEntity entity = (IntegrationContextEntity)this.repository.findById((Object)integrationContextId).orElseThrow(() -> new EntityNotFoundException("Unable to find integration context for the given id: '" + integrationContextId + "'"));
        return this.representationModelAssembler.toModel(entity);
    }
}

