/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.task.model.QueryCloudTask;
import org.activiti.cloud.services.query.app.repository.TaskCandidateGroupRepository;
import org.activiti.cloud.services.query.app.repository.TaskCandidateUserRepository;
import org.activiti.cloud.services.query.app.repository.TaskRepository;
import org.activiti.cloud.services.query.model.TaskCandidateGroupEntity;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.rest.ProcessVariableService;
import org.activiti.cloud.services.query.rest.VariableSearch;
import org.activiti.cloud.services.query.rest.assembler.TaskRepresentationModelAssembler;
import org.activiti.cloud.services.query.rest.payload.TaskSearchRequest;
import org.activiti.cloud.services.query.rest.predicate.QueryDslPredicateAggregator;
import org.activiti.cloud.services.query.rest.predicate.QueryDslPredicateFilter;
import org.activiti.cloud.services.query.rest.specification.TaskSpecification;
import org.activiti.cloud.services.security.TaskLookupRestrictionService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.transaction.annotation.Transactional;

public class TaskControllerHelper {
    private final TaskRepository taskRepository;
    private final TaskCandidateUserRepository taskCandidateUserRepository;
    private final TaskCandidateGroupRepository taskCandidateGroupRepository;
    private final ProcessVariableService processVariableService;
    private final AlfrescoPagedModelAssembler<TaskEntity> pagedCollectionModelAssembler;
    private final QueryDslPredicateAggregator predicateAggregator;
    private final TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private final TaskLookupRestrictionService taskLookupRestrictionService;
    private final SecurityManager securityManager;

    public TaskControllerHelper(TaskRepository taskRepository, TaskCandidateUserRepository taskCandidateUserRepository, TaskCandidateGroupRepository taskCandidateGroupRepository, ProcessVariableService processVariableService, AlfrescoPagedModelAssembler<TaskEntity> pagedCollectionModelAssembler, QueryDslPredicateAggregator predicateAggregator, TaskRepresentationModelAssembler taskRepresentationModelAssembler, TaskLookupRestrictionService taskLookupRestrictionService, SecurityManager securityManager) {
        this.taskRepository = taskRepository;
        this.taskCandidateUserRepository = taskCandidateUserRepository;
        this.taskCandidateGroupRepository = taskCandidateGroupRepository;
        this.processVariableService = processVariableService;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.predicateAggregator = predicateAggregator;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.taskLookupRestrictionService = taskLookupRestrictionService;
        this.securityManager = securityManager;
    }

    public PagedModel<EntityModel<QueryCloudTask>> findAll(Predicate predicate, VariableSearch variableSearch, Pageable pageable, List<QueryDslPredicateFilter> filters) {
        Page<TaskEntity> page = this.findPage(predicate, variableSearch, pageable, filters);
        return this.pagedCollectionModelAssembler.toModel(pageable, page, (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }

    @Transactional(readOnly=true)
    public PagedModel<EntityModel<QueryCloudTask>> findAllWithProcessVariables(Predicate predicate, VariableSearch variableSearch, Pageable pageable, List<QueryDslPredicateFilter> filters, List<String> processVariableKeys) {
        Page<TaskEntity> page = this.findPageWithProcessVariables(predicate, variableSearch, pageable, filters);
        this.processVariableService.fetchProcessVariablesForTasks((Collection<TaskEntity>)page.getContent(), processVariableKeys);
        return this.pagedCollectionModelAssembler.toModel(pageable, page, (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }

    @Transactional(readOnly=true)
    public PagedModel<EntityModel<QueryCloudTask>> searchTasksRestricted(TaskSearchRequest taskSearchRequest, Pageable pageable) {
        return this.searchTasks(taskSearchRequest, pageable, TaskSpecification.restricted(taskSearchRequest, this.securityManager.getAuthenticatedUserId(), this.securityManager.getAuthenticatedUserGroups()));
    }

    @Transactional(readOnly=true)
    public PagedModel<EntityModel<QueryCloudTask>> searchTasksUnrestricted(TaskSearchRequest taskSearchRequest, Pageable pageable) {
        return this.searchTasks(taskSearchRequest, pageable, TaskSpecification.unrestricted(taskSearchRequest));
    }

    private PagedModel<EntityModel<QueryCloudTask>> searchTasks(TaskSearchRequest taskSearchRequest, Pageable pageable, TaskSpecification taskSpecification) {
        Page tasks = this.taskRepository.findAll((Specification)taskSpecification, pageable);
        this.fetchTaskCandidateUsers(tasks.getContent());
        this.fetchTaskCandidateGroups(tasks.getContent());
        this.processVariableService.fetchProcessVariablesForTasks((Collection<TaskEntity>)tasks.getContent(), taskSearchRequest.processVariableKeys());
        return this.pagedCollectionModelAssembler.toModel(pageable, tasks, (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }

    public PagedModel<EntityModel<QueryCloudTask>> findAllByInvolvedUserQuery(Predicate predicate, Pageable pageable) {
        Page<TaskEntity> page = this.findAllByInvolvedUser(predicate, pageable);
        return this.pagedCollectionModelAssembler.toModel(pageable, page, (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }

    @Transactional(readOnly=true)
    public PagedModel<EntityModel<QueryCloudTask>> findAllFromBody(Predicate predicate, VariableSearch variableSearch, Pageable pageable, List<QueryDslPredicateFilter> filters, List<String> processVariableKeys) {
        if (processVariableKeys == null || processVariableKeys.isEmpty()) {
            return this.findAll(predicate, variableSearch, pageable, filters);
        }
        return this.findAllWithProcessVariables(predicate, variableSearch, pageable, filters, processVariableKeys);
    }

    @Transactional(readOnly=true)
    public PagedModel<EntityModel<QueryCloudTask>> findAllByInvolvedUserQueryWithProcessVariables(Predicate predicate, List<String> processVariableKeys, Pageable pageable) {
        Page<TaskEntity> page = this.findAllByInvolvedUser(predicate, pageable);
        this.processVariableService.fetchProcessVariablesForTasks((Collection<TaskEntity>)page.getContent(), processVariableKeys);
        return this.pagedCollectionModelAssembler.toModel(pageable, page, (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }

    private Page<TaskEntity> findAllByInvolvedUser(Predicate predicate, Pageable pageable) {
        Predicate conditions = this.taskLookupRestrictionService.restrictToInvolvedUsersQuery(predicate);
        return this.taskRepository.findInProcessInstanceScope(conditions, pageable);
    }

    public boolean canUserViewTask(Predicate predicate) {
        Predicate conditions = this.taskLookupRestrictionService.restrictToInvolvedUsersQuery(predicate);
        return this.taskRepository.existsInProcessInstanceScope(conditions);
    }

    private Page<TaskEntity> findPage(Predicate predicate, VariableSearch variableSearch, Pageable pageable, List<QueryDslPredicateFilter> filters) {
        Predicate extendedPredicate = this.predicateAggregator.applyFilters(predicate, filters);
        Page page = variableSearch.isSet() ? this.taskRepository.findByVariableNameAndValue(variableSearch.getName(), variableSearch.getValue(), extendedPredicate, pageable) : this.taskRepository.findAll(extendedPredicate, pageable);
        return page;
    }

    private Page<TaskEntity> findPageWithProcessVariables(Predicate predicate, VariableSearch variableSearch, Pageable pageable, List<QueryDslPredicateFilter> filters) {
        Predicate extendedPredicate = this.predicateAggregator.applyFilters(predicate, filters);
        if (variableSearch.isSet()) {
            return this.taskRepository.findByVariableNameAndValue(variableSearch.getName(), variableSearch.getValue(), extendedPredicate, pageable);
        }
        return this.taskRepository.findAll(extendedPredicate, pageable);
    }

    private void fetchTaskCandidateUsers(Collection<TaskEntity> tasks) {
        Map candidatesByTaskId = this.taskCandidateUserRepository.findByTaskIdIn((Collection)tasks.stream().map(TaskEntity::getId).collect(Collectors.toSet())).stream().collect(Collectors.groupingBy(TaskCandidateUserEntity::getTaskId, Collectors.toSet()));
        tasks.forEach(task -> task.setTaskCandidateUsers((Set)candidatesByTaskId.get(task.getId())));
    }

    private void fetchTaskCandidateGroups(Collection<TaskEntity> tasks) {
        Map candidatesByTaskId = this.taskCandidateGroupRepository.findByTaskIdIn(tasks.stream().map(TaskEntity::getId).collect(Collectors.toSet())).stream().collect(Collectors.groupingBy(TaskCandidateGroupEntity::getTaskId, Collectors.toSet()));
        tasks.forEach(task -> task.setTaskCandidateGroups((Set)candidatesByTaskId.get(task.getId())));
    }

    @Transactional(readOnly=true)
    public Long countTasksUnrestricted(TaskSearchRequest taskSearchRequest) {
        TaskSpecification unrestrictedTaskSpecification = TaskSpecification.unrestricted(taskSearchRequest);
        return this.taskRepository.count((Specification)unrestrictedTaskSpecification);
    }

    @Transactional(readOnly=true)
    public Long countTasksRestricted(TaskSearchRequest taskSearchRequest) {
        TaskSpecification restrictedTaskSpecification = TaskSpecification.restricted(taskSearchRequest, this.securityManager.getAuthenticatedUserId(), this.securityManager.getAuthenticatedUserGroups());
        return this.taskRepository.count((Specification)restrictedTaskSpecification);
    }
}

