/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.specification;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Set;
import org.activiti.cloud.services.query.app.repository.annotation.CountOverFullWindow;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity_;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity_;
import org.activiti.cloud.services.query.model.TaskEntity_;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceSearchRequest;
import org.activiti.cloud.services.query.rest.specification.SpecificationSupport;
import org.springframework.util.CollectionUtils;

@CountOverFullWindow
public class ProcessInstanceSpecification
extends SpecificationSupport<ProcessInstanceEntity, ProcessInstanceSearchRequest> {
    private final String userId;

    private ProcessInstanceSpecification(ProcessInstanceSearchRequest searchRequest, String userId) {
        super(searchRequest);
        this.userId = userId;
    }

    public static ProcessInstanceSpecification unrestricted(ProcessInstanceSearchRequest searchRequest) {
        return new ProcessInstanceSpecification(searchRequest, null);
    }

    public static ProcessInstanceSpecification restricted(ProcessInstanceSearchRequest searchRequest, String userId) {
        return new ProcessInstanceSpecification(searchRequest, userId);
    }

    public static ProcessInstanceSpecification unrestrictedLinkedProcesses(String linkedProcessInstanceId) {
        return ProcessInstanceSpecification.configureLinkedProcessSpecification(linkedProcessInstanceId, null);
    }

    public static ProcessInstanceSpecification restrictedLinkedProcesses(String linkedProcessInstanceId, String userId) {
        return ProcessInstanceSpecification.configureLinkedProcessSpecification(linkedProcessInstanceId, userId);
    }

    private static ProcessInstanceSpecification configureLinkedProcessSpecification(String linkedProcessInstanceId, String userId) {
        ProcessInstanceSearchRequest searchRequest = new ProcessInstanceSearchRequest();
        searchRequest.setLinkedProcessInstanceId(Set.of(linkedProcessInstanceId));
        return userId == null ? ProcessInstanceSpecification.unrestricted(searchRequest) : ProcessInstanceSpecification.restricted(searchRequest, userId);
    }

    @Override
    public Predicate toPredicate(Root<ProcessInstanceEntity> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        this.reset();
        this.applyUserRestrictionFilter(root, criteriaBuilder);
        this.applyIdFilter(root);
        this.applyParentIdFilter(root);
        this.applyNameFilter(root, criteriaBuilder);
        this.applyProcessDefinitionNameFilter(root);
        this.applyInitiatorFilter(root);
        this.applyAppVersionFilter(root);
        this.applyStatusFilter(root);
        this.applyLastModifiedDateFilters(root, criteriaBuilder);
        this.applyStartFilters(root, criteriaBuilder);
        this.applyCompletedFilters(root, criteriaBuilder);
        this.applySuspendedFilters(root, criteriaBuilder);
        this.applyIncludeSubprocesses(root);
        this.applyLinkedProcessInstanceId(root);
        this.applyLinkedProcessInstanceType(root);
        return super.toPredicate(root, query, criteriaBuilder);
    }

    private void applyIncludeSubprocesses(Root<ProcessInstanceEntity> root) {
        if (Boolean.FALSE.equals(((ProcessInstanceSearchRequest)this.searchRequest).getIncludeSubprocesses())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.parentId).isNull());
        }
    }

    @Override
    protected SingularAttribute<ProcessInstanceEntity, String> getIdAttribute() {
        return ProcessInstanceEntity_.id;
    }

    @Override
    protected SetAttribute<ProcessInstanceEntity, ProcessVariableEntity> getProcessVariablesAttribute() {
        return ProcessInstanceEntity_.variables;
    }

    private void applyParentIdFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).parentId())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.parentId).in(((ProcessInstanceSearchRequest)this.searchRequest).parentId()));
        }
    }

    private void applyLinkedProcessInstanceId(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).getLinkedProcessInstanceId())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.linkedProcessInstanceId).in(((ProcessInstanceSearchRequest)this.searchRequest).getLinkedProcessInstanceId()));
        }
    }

    private void applyLinkedProcessInstanceType(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).getLinkedProcessInstanceType())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.linkedProcessInstanceType).in(((ProcessInstanceSearchRequest)this.searchRequest).getLinkedProcessInstanceType()));
        }
    }

    private void applyNameFilter(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).getName())) {
            this.addLikeFilters(this.predicates, ((ProcessInstanceSearchRequest)this.searchRequest).getName(), root, criteriaBuilder, ProcessInstanceEntity_.name);
        }
    }

    private void applyProcessDefinitionNameFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).getProcessDefinitionName())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.processDefinitionName).in(((ProcessInstanceSearchRequest)this.searchRequest).getProcessDefinitionName()));
        }
    }

    private void applyInitiatorFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).getInitiator())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.initiator).in(((ProcessInstanceSearchRequest)this.searchRequest).getInitiator()));
        }
    }

    private void applyAppVersionFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).getAppVersion())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.appVersion).in(((ProcessInstanceSearchRequest)this.searchRequest).getAppVersion()));
        }
    }

    private void applyStatusFilter(Root<ProcessInstanceEntity> root) {
        if (!CollectionUtils.isEmpty(((ProcessInstanceSearchRequest)this.searchRequest).getStatus())) {
            this.predicates.add(root.get(ProcessInstanceEntity_.status).in(((ProcessInstanceSearchRequest)this.searchRequest).getStatus()));
        }
    }

    private void applyLastModifiedDateFilters(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((ProcessInstanceSearchRequest)this.searchRequest).getLastModifiedFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(ProcessInstanceEntity_.lastModified), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).getLastModifiedFrom()));
        }
        if (((ProcessInstanceSearchRequest)this.searchRequest).getLastModifiedTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(ProcessInstanceEntity_.lastModified), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).getLastModifiedTo()));
        }
    }

    private void applyStartFilters(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((ProcessInstanceSearchRequest)this.searchRequest).getStartFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(ProcessInstanceEntity_.startDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).getStartFrom()));
        }
        if (((ProcessInstanceSearchRequest)this.searchRequest).getStartTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(ProcessInstanceEntity_.startDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).getStartTo()));
        }
    }

    private void applyCompletedFilters(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((ProcessInstanceSearchRequest)this.searchRequest).getCompletedFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(ProcessInstanceEntity_.completedDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).getCompletedFrom()));
        }
        if (((ProcessInstanceSearchRequest)this.searchRequest).getCompletedTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(ProcessInstanceEntity_.completedDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).getCompletedTo()));
        }
    }

    private void applySuspendedFilters(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (((ProcessInstanceSearchRequest)this.searchRequest).getSuspendedFrom() != null) {
            this.predicates.add(criteriaBuilder.greaterThan((Expression)root.get(ProcessInstanceEntity_.suspendedDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).getSuspendedFrom()));
        }
        if (((ProcessInstanceSearchRequest)this.searchRequest).getSuspendedTo() != null) {
            this.predicates.add(criteriaBuilder.lessThan((Expression)root.get(ProcessInstanceEntity_.suspendedDate), (Comparable)((ProcessInstanceSearchRequest)this.searchRequest).getSuspendedTo()));
        }
    }

    private void applyUserRestrictionFilter(Root<ProcessInstanceEntity> root, CriteriaBuilder criteriaBuilder) {
        if (this.userId != null) {
            this.predicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.equal((Expression)root.get(ProcessInstanceEntity_.initiator), (Object)this.userId), criteriaBuilder.equal((Expression)root.join(ProcessInstanceEntity_.tasks, JoinType.LEFT).get(TaskEntity_.assignee), (Object)this.userId), criteriaBuilder.equal((Expression)root.join(ProcessInstanceEntity_.tasks, JoinType.LEFT).join(TaskEntity_.taskCandidateUsers, JoinType.LEFT).get(TaskCandidateUserEntity_.userId), (Object)this.userId)}));
        }
    }
}

