/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Optional;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.model.shared.QueryCloudVariableInstance;
import org.activiti.cloud.services.query.app.repository.VariableRepository;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.QProcessVariableEntity;
import org.activiti.cloud.services.query.rest.assembler.QueryCloudVariableInstanceRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/process-instances/{processInstanceId}"}, produces={"application/hal+json", "application/json"})
public class ProcessInstanceVariableController {
    private final VariableRepository variableRepository;
    private final QueryCloudVariableInstanceRepresentationModelAssembler variableRepresentationModelAssembler;
    private final AlfrescoPagedModelAssembler<ProcessVariableEntity> pagedCollectionModelAssembler;

    @Autowired
    public ProcessInstanceVariableController(QueryCloudVariableInstanceRepresentationModelAssembler variableRepresentationModelAssembler, VariableRepository variableRepository, AlfrescoPagedModelAssembler<ProcessVariableEntity> pagedCollectionModelAssembler) {
        this.variableRepository = variableRepository;
        this.variableRepresentationModelAssembler = variableRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
    }

    @RequestMapping(value={"/variables"}, method={RequestMethod.GET})
    public PagedModel<EntityModel<QueryCloudVariableInstance>> getVariablesProcess(@PathVariable String processInstanceId, @Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessVariableEntity.class) Predicate predicate, Pageable pageable) {
        predicate = Optional.ofNullable(predicate).orElseGet(BooleanBuilder::new);
        QProcessVariableEntity variable = QProcessVariableEntity.processVariableEntity;
        BooleanExpression expression = variable.processInstanceId.eq((Object)processInstanceId);
        if (predicate != null) {
            expression = expression.and(predicate);
        }
        BooleanExpression extendedPredicate = expression;
        Page variables = this.variableRepository.findAll((Predicate)extendedPredicate, pageable);
        return this.pagedCollectionModelAssembler.toModel(pageable, variables, (RepresentationModelAssembler)this.variableRepresentationModelAssembler);
    }
}

