/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.security;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.JPAExpressions;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.cloud.services.query.model.QProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QTaskCandidateGroupEntity;
import org.activiti.cloud.services.query.model.QTaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.QTaskEntity;
import org.activiti.cloud.services.query.model.QTaskVariableEntity;
import org.activiti.cloud.services.query.rest.predicate.QueryDslPredicateFilter;
import org.springframework.beans.factory.annotation.Value;

public class TaskLookupRestrictionService
implements QueryDslPredicateFilter {
    private final SecurityManager securityManager;
    @Value(value="${activiti.cloud.security.task.restrictions.enabled:true}")
    private boolean restrictionsEnabled;
    @Value(value="${activiti.cloud.security.task.restrictions.involved.user.enabled:true}")
    private boolean restrictionsInvolvedUserEnabled;

    public TaskLookupRestrictionService(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public Predicate restrictTaskQuery(Predicate predicate) {
        return this.restrictTaskQuery(predicate, QTaskEntity.taskEntity);
    }

    @Override
    public Predicate extend(@NotNull Predicate currentPredicate) {
        return this.restrictTaskQuery(currentPredicate);
    }

    public Predicate restrictTaskVariableQuery(Predicate predicate) {
        QTaskEntity task = QTaskVariableEntity.taskVariableEntity.task;
        Predicate extendedPredicate = this.addAndConditionToPredicate(predicate, task.isNotNull());
        return this.restrictTaskQuery(extendedPredicate, task);
    }

    public Predicate restrictToInvolvedUsersQuery(Predicate predicate) {
        if (!this.restrictionsInvolvedUserEnabled) {
            return this.restrictTaskQuery(predicate);
        }
        QTaskEntity taskEntity = QTaskEntity.taskEntity;
        QProcessInstanceEntity processInstanceEntity = QProcessInstanceEntity.processInstanceEntity;
        String userId = this.securityManager.getAuthenticatedUserId();
        Predicate defaultRestrictions = this.restrictTaskQuery((Predicate)new BooleanBuilder());
        BooleanExpression userIsInvolved = processInstanceEntity.initiator.eq((Object)userId).or((Predicate)taskEntity.processInstanceId.in((SubQueryExpression)JPAExpressions.select((Expression)taskEntity.processInstanceId).from(new EntityPath[]{taskEntity}).where(new Predicate[]{defaultRestrictions}))).or(defaultRestrictions);
        return this.addAndConditionToPredicate(predicate, userIsInvolved);
    }

    private Predicate restrictTaskQuery(Predicate predicate, QTaskEntity task) {
        if (!this.restrictionsEnabled) {
            return predicate;
        }
        String userId = this.securityManager.getAuthenticatedUserId();
        BooleanExpression restriction = null;
        if (userId != null) {
            BooleanExpression isNotAssigned = task.assignee.isNull();
            restriction = task.assignee.eq((Object)userId).or((Predicate)task.owner.eq((Object)userId)).or((Predicate)((QTaskCandidateUserEntity)task.taskCandidateUsers.any()).userId.eq((Object)userId).and((Predicate)isNotAssigned));
            List groups = null;
            if (this.securityManager != null) {
                groups = this.securityManager.getAuthenticatedUserGroups();
            }
            if (groups != null && groups.size() > 0) {
                restriction = restriction.or((Predicate)((QTaskCandidateGroupEntity)task.taskCandidateGroups.any()).groupId.in((Collection)groups).and((Predicate)isNotAssigned));
            }
            restriction = restriction.or((Predicate)task.taskCandidateUsers.isEmpty().and((Predicate)task.taskCandidateGroups.isEmpty()).and((Predicate)isNotAssigned));
        }
        return this.addAndConditionToPredicate(predicate, restriction);
    }

    private Predicate addAndConditionToPredicate(Predicate predicate, BooleanExpression expression) {
        if (expression != null && predicate != null) {
            return expression.and(predicate);
        }
        if (expression == null) {
            return predicate;
        }
        return expression;
    }

    public void setRestrictionsEnabled(boolean restrictionsEnabled) {
        this.restrictionsEnabled = restrictionsEnabled;
    }

    public boolean isRestrictionsEnabled() {
        return this.restrictionsEnabled;
    }

    public boolean isRestrictionsInvolvedUserEnabled() {
        return this.restrictionsInvolvedUserEnabled;
    }

    public void setRestrictionsInvolvedUserEnabled(boolean restrictionsInvolvedUserEnabled) {
        this.restrictionsInvolvedUserEnabled = restrictionsInvolvedUserEnabled;
    }
}

