/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Optional;
import org.activiti.cloud.api.process.model.QueryCloudProcessInstance;
import org.activiti.cloud.services.query.app.repository.BPMNActivityRepository;
import org.activiti.cloud.services.query.app.repository.BPMNSequenceFlowRepository;
import org.activiti.cloud.services.query.app.repository.ProcessInstanceRepository;
import org.activiti.cloud.services.query.app.repository.ServiceTaskRepository;
import org.activiti.cloud.services.query.app.repository.TaskRepository;
import org.activiti.cloud.services.query.app.repository.VariableRepository;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.rest.assembler.ProcessInstanceRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(name={"activiti.rest.enable-deletion"}, matchIfMissing=true)
@RestController
@RequestMapping(value={"/admin/v1/process-instances"}, produces={"application/hal+json", "application/json"})
public class ProcessInstanceDeleteController {
    private final ProcessInstanceRepository processInstanceRepository;
    private final TaskRepository taskRepository;
    private final VariableRepository variableRepository;
    private final ServiceTaskRepository serviceTaskRepository;
    private final BPMNActivityRepository bpmnActivityRepository;
    private final BPMNSequenceFlowRepository bpmnSequenceFlowRepository;
    private ProcessInstanceRepresentationModelAssembler processInstanceRepresentationModelAssembler;

    @Autowired
    public ProcessInstanceDeleteController(ProcessInstanceRepository processInstanceRepository, TaskRepository taskRepository, VariableRepository variableRepository, ServiceTaskRepository serviceTaskRepository, BPMNActivityRepository bpmnActivityRepository, BPMNSequenceFlowRepository bpmnSequenceFlowRepository, ProcessInstanceRepresentationModelAssembler processInstanceRepresentationModelAssembler) {
        this.processInstanceRepository = processInstanceRepository;
        this.taskRepository = taskRepository;
        this.variableRepository = variableRepository;
        this.serviceTaskRepository = serviceTaskRepository;
        this.bpmnActivityRepository = bpmnActivityRepository;
        this.bpmnSequenceFlowRepository = bpmnSequenceFlowRepository;
        this.processInstanceRepresentationModelAssembler = processInstanceRepresentationModelAssembler;
    }

    @JsonView(value={JsonViews.General.class})
    @RequestMapping(method={RequestMethod.DELETE})
    @Transactional
    public CollectionModel<EntityModel<QueryCloudProcessInstance>> deleteProcessInstances(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessInstanceEntity.class) Predicate predicate) {
        ArrayList<EntityModel<QueryCloudProcessInstance>> result = new ArrayList<EntityModel<QueryCloudProcessInstance>>();
        Iterable iterable = this.processInstanceRepository.findAll(predicate);
        for (ProcessInstanceEntity entity : iterable) {
            Optional.ofNullable(entity.getTasks()).ifPresent(arg_0 -> ((TaskRepository)this.taskRepository).deleteAll(arg_0));
            Optional.ofNullable(entity.getVariables()).ifPresent(arg_0 -> ((VariableRepository)this.variableRepository).deleteAll(arg_0));
            Optional.ofNullable(entity.getServiceTasks()).ifPresent(arg_0 -> ((ServiceTaskRepository)this.serviceTaskRepository).deleteAll(arg_0));
            Optional.ofNullable(entity.getActivities()).ifPresent(arg_0 -> ((BPMNActivityRepository)this.bpmnActivityRepository).deleteAll(arg_0));
            Optional.ofNullable(entity.getSequenceFlows()).ifPresent(arg_0 -> ((BPMNSequenceFlowRepository)this.bpmnSequenceFlowRepository).deleteAll(arg_0));
            result.add(this.processInstanceRepresentationModelAssembler.toModel(entity));
        }
        this.processInstanceRepository.deleteAll(iterable);
        return CollectionModel.of(result);
    }
}

