/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.specification;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.math.BigDecimal;
import java.util.Map;
import org.activiti.cloud.dialect.CustomPostgreSQLDialect;
import org.activiti.cloud.services.query.model.AbstractVariableEntity;
import org.activiti.cloud.services.query.model.AbstractVariableEntity_;
import org.activiti.cloud.services.query.rest.specification.VariableSelectionExpression;

public class VariableSelectionExpressionImpl<R, K extends AbstractVariableEntity>
implements VariableSelectionExpression {
    protected final From<R, K> root;
    private final Predicate selectionPredicate;
    private Expression<?> selectionExpression;
    protected final Class<?> variableJavaType;
    protected final CriteriaBuilder criteriaBuilder;

    public VariableSelectionExpressionImpl(From<R, K> root, Map<Path<String>, String> selectionFilters, Class<?> variableJavaType, CriteriaBuilder criteriaBuilder) {
        this.root = root;
        this.variableJavaType = variableJavaType;
        this.criteriaBuilder = criteriaBuilder;
        this.selectionPredicate = criteriaBuilder.and((Predicate[])selectionFilters.entrySet().stream().map(entry -> criteriaBuilder.equal((Expression)entry.getKey(), entry.getValue())).toArray(Predicate[]::new));
    }

    public Expression getExtractedValue() {
        String extractionFunctionName = CustomPostgreSQLDialect.getExtractionFunctionName(this.variableJavaType);
        Class<?> extractionFunctionReturnType = this.variableJavaType == Boolean.class || this.variableJavaType == BigDecimal.class ? this.variableJavaType : String.class;
        Expression extractedValue = this.criteriaBuilder.function(extractionFunctionName, extractionFunctionReturnType, new Expression[]{this.root.get(AbstractVariableEntity_.value)});
        if (this.variableJavaType != BigDecimal.class) {
            Class castType = this.variableJavaType == Boolean.class ? Integer.class : this.variableJavaType;
            extractedValue = extractedValue.as(castType);
        }
        return extractedValue;
    }

    public Expression getSelectionExpression() {
        if (this.selectionExpression == null) {
            this.selectionExpression = this.criteriaBuilder.greatest(this.criteriaBuilder.selectCase().when((Expression)this.selectionPredicate, this.getExtractedValue()).otherwise(this.criteriaBuilder.nullLiteral(this.variableJavaType)));
        }
        return this.selectionExpression;
    }
}

