/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.exceptions.XMLException;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.image.ProcessDiagramGenerator;
import org.activiti.image.exception.ActivitiImageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class ProcessDiagramGeneratorWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDiagramGeneratorWrapper.class);
    private final ProcessDiagramGenerator processDiagramGenerator;
    @Value(value="${activiti.diagram.activity.font:}")
    private String activityFontName;
    @Value(value="${activiti.diagram.label.font:}")
    private String labelFontName;
    @Value(value="${activiti.diagram.annotation.font:}")
    private String annotationFontName;
    @Value(value="${activiti.diagram.default.image.file:}")
    private String defaultDiagramImageFileName;
    @Value(value="${activiti.diagram.generate.default:true}")
    private boolean generateDefaultDiagram;
    @Value(value="${activiti.diagram.font.default:Serif}")
    private String diagramDefaultFont;

    @Autowired
    public ProcessDiagramGeneratorWrapper(ProcessDiagramGenerator processDiagramGenerator) {
        this.processDiagramGenerator = processDiagramGenerator;
    }

    public byte[] generateDiagram(BpmnModel bpmnModel) {
        return this.generateDiagram(bpmnModel, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public byte[] generateDiagram(BpmnModel bpmnModel, List<String> highLightedActivities, List<String> highLightedFlows, List<String> currentActivities, List<String> erroredActivities) {
        byte[] byArray;
        block9: {
            InputStream imageStream = this.processDiagramGenerator.generateDiagram(bpmnModel, highLightedActivities, highLightedFlows, currentActivities, erroredActivities, this.getActivityFontName(), this.getLabelFontName(), this.getAnnotationFontName(), this.isGenerateDefaultDiagram(), this.getDiagramImageFileName());
            try {
                byArray = StreamUtils.copyToByteArray((InputStream)imageStream);
                if (imageStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (imageStream != null) {
                        try {
                            imageStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ActivitiImageException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error occurred while getting process diagram for model: " + String.valueOf(bpmnModel), e);
                }
            }
            imageStream.close();
        }
        return byArray;
    }

    public boolean isGenerateDefaultDiagram() {
        return this.generateDefaultDiagram;
    }

    public String getDefaultDiagramImageFileName() {
        return this.defaultDiagramImageFileName;
    }

    public String getDiagramImageFileName() {
        return !StringUtils.isEmpty((Object)this.getDefaultDiagramImageFileName()) ? this.getDefaultDiagramImageFileName() : this.processDiagramGenerator.getDefaultDiagramImageFileName();
    }

    public String getActivityFontName() {
        return this.isFontAvailable(this.activityFontName) ? this.activityFontName : this.getDiagramDefaultFont();
    }

    public String getLabelFontName() {
        return this.isFontAvailable(this.labelFontName) ? this.labelFontName : this.getDiagramDefaultFont();
    }

    public String getAnnotationFontName() {
        return this.isFontAvailable(this.annotationFontName) ? this.annotationFontName : this.getDiagramDefaultFont();
    }

    private boolean isFontAvailable(String fontName) {
        if (StringUtils.isEmpty((Object)fontName)) {
            return false;
        }
        boolean available = Arrays.stream(this.getAvailableFonts()).anyMatch(availbleFontName -> availbleFontName.toLowerCase().startsWith(fontName.toLowerCase()));
        if (!available) {
            LOGGER.debug("Font not available while generating process diagram: " + fontName);
        }
        return available;
    }

    protected String[] getAvailableFonts() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public String getDiagramDefaultFont() {
        return this.diagramDefaultFont;
    }

    public void setDiagramDefaultFont(String diagramDefaultFont) {
        this.diagramDefaultFont = diagramDefaultFont;
    }

    public BpmnModel parseBpmnModelXml(InputStream inputStream) {
        InputStreamReader in = null;
        try {
            in = new InputStreamReader(inputStream);
            XMLInputFactory xif = XMLInputFactory.newInstance();
            if (xif.isPropertySupported("javax.xml.stream.isReplacingEntityReferences")) {
                xif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            }
            if (xif.isPropertySupported("javax.xml.stream.isSupportingExternalEntities")) {
                xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            }
            if (xif.isPropertySupported("javax.xml.stream.supportDTD")) {
                xif.setProperty("javax.xml.stream.supportDTD", false);
            }
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
            return bpmnModel;
        }
        catch (XMLStreamException e) {
            throw new XMLException("Error while reading the BPMN 2.0 XML", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

