/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.api.task.model.Task;
import org.activiti.cloud.services.query.app.repository.VariableRepository;
import org.activiti.cloud.services.query.model.AbstractVariableEntity;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.ProcessVariableKey;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.rest.specification.ProcessVariableSpecification;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

public class ProcessVariableService {
    private final VariableRepository variableRepository;

    public ProcessVariableService(VariableRepository variableRepository) {
        this.variableRepository = variableRepository;
    }

    public void fetchProcessVariablesForProcessInstances(Collection<ProcessInstanceEntity> processInstances, Set<ProcessVariableKey> variableKeys) {
        if (!CollectionUtils.isEmpty(variableKeys)) {
            Set<String> processInstanceIds = processInstances.stream().map(ProcessInstanceEntity::getId).collect(Collectors.toSet());
            Map<String, Set<ProcessVariableEntity>> processVariablesMap = this.fetchVariablesInternal(processInstanceIds, variableKeys);
            processInstances.forEach(pi -> pi.setVariables(processVariablesMap.getOrDefault(pi.getId(), Collections.emptySet())));
        } else {
            processInstances.forEach(pi -> pi.setVariables(Collections.emptySet()));
        }
    }

    public void fetchProcessVariablesForTasks(Collection<TaskEntity> tasks, Collection<String> processVariableFetchKeys) {
        this.fetchProcessVariablesForTasks(tasks, processVariableFetchKeys.stream().map(ProcessVariableKey::fromString).collect(Collectors.toSet()));
    }

    public void fetchProcessVariablesForTasks(Collection<TaskEntity> tasks, Set<ProcessVariableKey> processVariableFetchKeys) {
        if (!CollectionUtils.isEmpty(processVariableFetchKeys)) {
            Set<String> processInstanceIds = tasks.stream().map(Task::getProcessInstanceId).collect(Collectors.toSet());
            Map<String, Set<ProcessVariableEntity>> processVariablesMap = this.fetchVariablesInternal(processInstanceIds, processVariableFetchKeys);
            tasks.forEach(task -> task.setProcessVariables(processVariablesMap.getOrDefault(task.getProcessInstanceId(), Collections.emptySet())));
        } else {
            tasks.forEach(task -> task.setProcessVariables(Collections.emptySet()));
        }
    }

    private Map<String, Set<ProcessVariableEntity>> fetchVariablesInternal(Set<String> processInstanceIds, Set<ProcessVariableKey> processVariableFetchKeys) {
        List processVariables = (List)this.variableRepository.findBy((Specification)new ProcessVariableSpecification(processInstanceIds, processVariableFetchKeys), q -> q.project(new String[]{"value"}).all());
        return processVariables.stream().collect(Collectors.groupingBy(AbstractVariableEntity::getProcessInstanceId, Collectors.toSet()));
    }
}

