/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest.specification;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.ProcessVariableEntity_;
import org.activiti.cloud.services.query.rest.filter.VariableFilter;
import org.activiti.cloud.services.query.rest.filter.VariableType;
import org.activiti.cloud.services.query.rest.payload.CloudRuntimeEntityFilterRequest;
import org.activiti.cloud.services.query.rest.payload.CloudRuntimeEntitySort;
import org.activiti.cloud.services.query.rest.specification.VariableSelectionExpressionImpl;
import org.activiti.cloud.services.query.rest.specification.VariableValueFilterCondition;
import org.activiti.cloud.services.query.rest.specification.VariableValueFilterConditionImpl;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ResponseStatusException;

public abstract class SpecificationSupport<T, R extends CloudRuntimeEntityFilterRequest>
implements Specification<T> {
    protected final R searchRequest;
    protected List<Predicate> predicates;
    protected List<VariableValueFilterCondition> filterConditions;
    private SetJoin<T, ProcessVariableEntity> pvJoin;
    protected final Map<VariableType, Class<?>> javaTypeMapping = Map.of(VariableType.STRING, String.class, VariableType.INTEGER, Integer.class, VariableType.BIGDECIMAL, BigDecimal.class, VariableType.DATE, LocalDate.class, VariableType.DATETIME, LocalDateTime.class, VariableType.BOOLEAN, Boolean.class);

    protected SpecificationSupport(R searchRequest) {
        this.searchRequest = searchRequest;
    }

    protected abstract SingularAttribute<T, ?> getIdAttribute();

    protected void reset() {
        this.predicates = new ArrayList<Predicate>();
        this.filterConditions = new ArrayList<VariableValueFilterCondition>();
        this.pvJoin = null;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        this.applyProcessVariableFilters(this.joinProcessVariables(root), criteriaBuilder);
        if (!this.filterConditions.isEmpty()) {
            query.groupBy(new Expression[]{root.get(this.getIdAttribute())});
            query.having((Expression)this.filterConditions.stream().map(VariableValueFilterCondition::getPredicate).reduce((arg_0, arg_1) -> ((CriteriaBuilder)criteriaBuilder).and(arg_0, arg_1)).orElse(criteriaBuilder.conjunction()));
        }
        if (!query.getResultType().equals(Long.class)) {
            this.applySorting(root, this.joinProcessVariables(root), query, criteriaBuilder);
        }
        if (CollectionUtils.isEmpty((Collection)query.getGroupList())) {
            query.distinct(true);
        }
        if (this.predicates.isEmpty()) {
            return criteriaBuilder.conjunction();
        }
        return criteriaBuilder.and((Predicate[])this.predicates.toArray(Predicate[]::new));
    }

    protected void applyProcessVariableFilters(Supplier<SetJoin<T, ProcessVariableEntity>> joinSupplier, CriteriaBuilder criteriaBuilder) {
        if (!CollectionUtils.isEmpty(this.searchRequest.processVariableFilters())) {
            SetJoin<T, ProcessVariableEntity> pvRoot = joinSupplier.get();
            this.filterConditions.addAll(this.searchRequest.processVariableFilters().stream().map(filter -> new VariableValueFilterConditionImpl(pvRoot, Map.of(pvRoot.get(ProcessVariableEntity_.processDefinitionKey), filter.processDefinitionKey(), pvRoot.get(ProcessVariableEntity_.name), filter.name()), this.javaTypeMapping.get((Object)filter.type()), (VariableFilter)filter, criteriaBuilder)).toList());
        }
    }

    protected void applyIdFilter(Root<T> root) {
        if (!CollectionUtils.isEmpty(this.searchRequest.id())) {
            this.predicates.add(root.get(this.getIdAttribute()).in(this.searchRequest.id()));
        }
    }

    protected void addLikeFilters(Collection<Predicate> predicates, Set<String> valuesToFilter, Root<T> root, CriteriaBuilder criteriaBuilder, SingularAttribute<T, String> attribute) {
        predicates.add(valuesToFilter.stream().map(value -> criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get(attribute)), "%" + value.toLowerCase() + "%")).reduce((arg_0, arg_1) -> ((CriteriaBuilder)criteriaBuilder).or(arg_0, arg_1)).orElse(criteriaBuilder.conjunction()));
    }

    protected void applySorting(Root<T> root, Supplier<SetJoin<T, ProcessVariableEntity>> joinSupplier, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        CloudRuntimeEntitySort sort = this.searchRequest.sort();
        if (sort != null) {
            Path orderByClause;
            this.validateSort(sort);
            if (sort.isProcessVariable()) {
                From joinRoot = (From)joinSupplier.get();
                orderByClause = new VariableSelectionExpressionImpl(joinRoot, Map.of(joinRoot.get(ProcessVariableEntity_.processDefinitionKey), sort.processDefinitionKey(), joinRoot.get(ProcessVariableEntity_.name), sort.field()), this.javaTypeMapping.get((Object)sort.type()), criteriaBuilder).getSelectionExpression();
                query.groupBy(new Expression[]{root.get(this.getIdAttribute())});
            } else {
                orderByClause = root.get(sort.field());
            }
            query.orderBy(new Order[]{sort.direction().isAscending() ? criteriaBuilder.asc((Expression)orderByClause) : criteriaBuilder.desc((Expression)orderByClause)});
        }
    }

    protected void validateSort(CloudRuntimeEntitySort sort) {
        if (sort.isProcessVariable()) {
            if (sort.processDefinitionKey() == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Process definition key is required when sorting by process variable");
            }
            if (sort.type() == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Variable type is required when sorting by process variable");
            }
        }
    }

    protected Supplier<SetJoin<T, ProcessVariableEntity>> joinProcessVariables(Root<T> root) {
        return () -> {
            if (this.pvJoin == null) {
                this.pvJoin = root.join(this.getProcessVariablesAttribute(), JoinType.LEFT);
            }
            return this.pvJoin;
        };
    }

    protected abstract SetAttribute<T, ProcessVariableEntity> getProcessVariablesAttribute();
}

