/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.types.Predicate;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.task.model.QueryCloudTask;
import org.activiti.cloud.services.query.app.repository.TaskRepository;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.QTaskEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.rest.assembler.TaskRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/process-instances/{processInstanceId}"}, produces={"application/hal+json", "application/json"})
public class ProcessInstanceTasksAdminController {
    private TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private AlfrescoPagedModelAssembler<TaskEntity> pagedCollectionModelAssembler;
    private final TaskRepository taskRepository;

    @Autowired
    public ProcessInstanceTasksAdminController(TaskRepository taskRepository, TaskRepresentationModelAssembler taskRepresentationModelAssembler, AlfrescoPagedModelAssembler<TaskEntity> pagedCollectionModelAssembler) {
        this.taskRepository = taskRepository;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
    }

    @JsonView(value={JsonViews.General.class})
    @RequestMapping(value={"/tasks"}, method={RequestMethod.GET})
    public PagedModel<EntityModel<QueryCloudTask>> getTasksAdmin(@PathVariable String processInstanceId, Pageable pageable) {
        Page page = this.taskRepository.findAll((Predicate)QTaskEntity.taskEntity.processInstanceId.eq((Object)processInstanceId), pageable);
        return this.pagedCollectionModelAssembler.toModel(pageable, page, (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }
}

