/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.QueryCloudProcessInstance;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.rest.assembler.ProcessInstanceRepresentationModelAssembler;
import org.activiti.cloud.services.query.rest.helper.ProcessInstanceControllerHelper;
import org.activiti.cloud.services.query.rest.payload.LinkProcessInstancesRequest;
import org.activiti.cloud.services.query.rest.payload.ProcessInstanceSearchRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/v1/process-instances"}, produces={"application/hal+json", "application/json"})
public class ProcessInstanceController {
    private final ProcessInstanceRepresentationModelAssembler processInstanceRepresentationModelAssembler;
    private final AlfrescoPagedModelAssembler<ProcessInstanceEntity> pagedCollectionModelAssembler;
    private final ProcessInstanceControllerHelper processInstanceControllerHelper;

    @Autowired
    public ProcessInstanceController(ProcessInstanceRepresentationModelAssembler processInstanceRepresentationModelAssembler, AlfrescoPagedModelAssembler<ProcessInstanceEntity> pagedCollectionModelAssembler, ProcessInstanceControllerHelper processInstanceControllerHelper) {
        this.processInstanceRepresentationModelAssembler = processInstanceRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.processInstanceControllerHelper = processInstanceControllerHelper;
    }

    @Operation(summary="Find process instances", hidden=true)
    @JsonView(value={JsonViews.General.class})
    @RequestMapping(method={RequestMethod.GET}, params={"!variableKeys"})
    public PagedModel<EntityModel<QueryCloudProcessInstance>> findAllProcessInstances(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessInstanceEntity.class) Predicate predicate, Pageable pageable) {
        return this.pagedCollectionModelAssembler.toModel(pageable, this.processInstanceControllerHelper.findAllProcessInstances(predicate, pageable), (RepresentationModelAssembler)this.processInstanceRepresentationModelAssembler);
    }

    @Operation(summary="Find process instances")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @RequestMapping(method={RequestMethod.GET}, params={"variableKeys"})
    public PagedModel<EntityModel<QueryCloudProcessInstance>> findAllWithVariables(@Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessInstanceEntity.class) Predicate predicate, @Parameter(description="Used to retrieve process variables. It is constructed from process definition key and variable name, e.g.: {processDefinitionKey}/{variableName}.", example="Process_90W_3nLpw/initializedVar") @RequestParam(value="variableKeys", required=false, defaultValue="") List<String> variableKeys, Pageable pageable) {
        return this.pagedCollectionModelAssembler.toModel(pageable, this.processInstanceControllerHelper.findAllProcessInstancesWithVariables(predicate, variableKeys, pageable), (RepresentationModelAssembler)this.processInstanceRepresentationModelAssembler);
    }

    @Operation(summary="Search process instances")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @PostMapping(value={"/search"})
    public PagedModel<EntityModel<QueryCloudProcessInstance>> searchProcessInstances(@RequestBody ProcessInstanceSearchRequest searchRequest, Pageable pageable) {
        return this.pagedCollectionModelAssembler.toModel(pageable, this.processInstanceControllerHelper.searchProcessInstances(searchRequest, pageable), (RepresentationModelAssembler)this.processInstanceRepresentationModelAssembler);
    }

    @JsonView(value={JsonViews.General.class})
    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.GET})
    public EntityModel<QueryCloudProcessInstance> findByIdProcess(@PathVariable String processInstanceId) {
        return this.processInstanceRepresentationModelAssembler.toModel(this.processInstanceControllerHelper.findById(processInstanceId));
    }

    @JsonView(value={JsonViews.General.class})
    @RequestMapping(value={"/{processInstanceId}/subprocesses"}, method={RequestMethod.GET})
    public PagedModel<EntityModel<QueryCloudProcessInstance>> subprocesses(@PathVariable String processInstanceId, @Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ProcessInstanceEntity.class) Predicate predicate, Pageable pageable) {
        return this.pagedCollectionModelAssembler.toModel(pageable, this.processInstanceControllerHelper.searchSubprocesses(processInstanceId, predicate, pageable), (RepresentationModelAssembler)this.processInstanceRepresentationModelAssembler);
    }

    @Operation(summary="Count process instances")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @PostMapping(value={"/count"})
    public Long countProcessInstances(@RequestBody ProcessInstanceSearchRequest searchRequest) {
        return this.processInstanceControllerHelper.countProcessInstances(searchRequest);
    }

    @Operation(summary="Link orphan process instances to a main process instance")
    @PostMapping(value={"/{mainProcessInstanceId}/link"})
    public void linkProcessInstances(@RequestBody LinkProcessInstancesRequest request, @PathVariable String mainProcessInstanceId) {
        try {
            this.processInstanceControllerHelper.linkProcessInstances(request, mainProcessInstanceId);
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to link process instances", (Throwable)e);
        }
    }
}

