/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.query.rest;

import org.activiti.cloud.services.query.model.VariableValue;

public class VariableSearch {

    private String name;

    private VariableValue<?> value;

    private String type;

    public VariableSearch(String name, VariableValue<?> value, String type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public VariableValue<?> getValue() {
        return value;
    }

    public String getType() {
        return type;
    }

    public boolean isSet() {
        return name != null && value != null && value.getValue() != null;
    }
}
