/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.security;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.StringPath;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.cloud.services.query.model.QProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QTaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.QTaskEntity;
import org.activiti.cloud.services.security.ProcessDefinitionKeyBasedRestrictionBuilder;
import org.activiti.cloud.services.security.ProcessInstanceFilter;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesManager;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;

public class ProcessInstanceRestrictionService {
    private SecurityPoliciesManager securityPoliciesManager;
    private ProcessInstanceFilter processInstanceFilter;
    private ProcessDefinitionKeyBasedRestrictionBuilder restrictionBuilder;
    private SecurityManager securityManager;

    public ProcessInstanceRestrictionService(SecurityPoliciesManager securityPoliciesManager, ProcessInstanceFilter processInstanceFilter, ProcessDefinitionKeyBasedRestrictionBuilder restrictionBuilder, SecurityManager securityManager) {
        this.securityPoliciesManager = securityPoliciesManager;
        this.processInstanceFilter = processInstanceFilter;
        this.restrictionBuilder = restrictionBuilder;
        this.securityManager = securityManager;
    }

    public Predicate restrictProcessInstanceQuery(Predicate predicate, SecurityPolicyAccess securityPolicyAccess) {
        Predicate initiatorPredicate = this.applyInvolvedRestriction(predicate);
        if (!this.securityPoliciesManager.arePoliciesDefined()) {
            return initiatorPredicate;
        }
        return this.restrictionBuilder.applyProcessDefinitionKeyFilter(initiatorPredicate, securityPolicyAccess, this.processInstanceFilter);
    }

    private Predicate applyInvolvedRestriction(Predicate predicate) {
        String userId = this.securityManager.getAuthenticatedUserId();
        if (userId == null) {
            return predicate;
        }
        StringPath initiatorPath = QProcessInstanceEntity.processInstanceEntity.initiator;
        BooleanExpression assigneeExpression = ((QTaskEntity)QProcessInstanceEntity.processInstanceEntity.tasks.any()).assignee.eq((Object)userId);
        BooleanExpression candidateExpression = ((QTaskCandidateUserEntity)((QTaskEntity)QProcessInstanceEntity.processInstanceEntity.tasks.any()).taskCandidateUsers.any()).userId.eq((Object)userId);
        return initiatorPath.eq((Object)userId).or((Predicate)assigneeExpression).or((Predicate)candidateExpression).and(predicate);
    }
}

