/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.api;

import feign.CollectionFormat;
import io.swagger.v3.oas.annotations.Parameter;
import org.activiti.api.process.model.payloads.CreateProcessInstancePayload;
import org.activiti.api.process.model.payloads.ReceiveMessagePayload;
import org.activiti.api.process.model.payloads.SignalPayload;
import org.activiti.api.process.model.payloads.StartMessagePayload;
import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.api.process.model.payloads.UpdateProcessPayload;
import org.activiti.cloud.api.process.model.CloudProcessInstance;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

public interface ProcessInstanceController {
    @GetMapping(value={"/v1/process-instances"})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public PagedModel<EntityModel<CloudProcessInstance>> getProcessInstances(Pageable var1);

    @PostMapping(path={"/v1/process-instances"}, consumes={"application/json"})
    public EntityModel<CloudProcessInstance> startProcess(@RequestBody StartProcessPayload var1);

    @Deprecated
    @PostMapping(value={"/v1/process-instances/{processInstanceId}/start"}, consumes={"application/json"})
    public EntityModel<CloudProcessInstance> startCreatedProcess(@PathVariable(value="processInstanceId") String var1, @RequestBody(required=false) StartProcessPayload var2);

    @Deprecated
    @PostMapping(value={"/v1/process-instances/create"}, consumes={"application/json"})
    public EntityModel<CloudProcessInstance> createProcessInstance(@RequestBody CreateProcessInstancePayload var1);

    @GetMapping(value={"/v1/process-instances/{processInstanceId}"})
    public EntityModel<CloudProcessInstance> getProcessInstanceById(@PathVariable(value="processInstanceId") String var1);

    @GetMapping(value={"/v1/process-instances/{processInstanceId}/model"}, produces={"image/svg+xml"})
    @ResponseBody
    public String getProcessDiagram(@PathVariable(value="processInstanceId") String var1);

    @PostMapping(value={"/v1/process-instances/signal"}, consumes={"application/json"})
    public ResponseEntity<Void> sendSignal(@RequestBody SignalPayload var1);

    @PostMapping(value={"/v1/process-instances/message"}, consumes={"application/json"})
    public EntityModel<CloudProcessInstance> sendStartMessage(@RequestBody StartMessagePayload var1);

    @PutMapping(value={"/v1/process-instances/message"}, consumes={"application/json"})
    public ResponseEntity<Void> receive(@RequestBody ReceiveMessagePayload var1);

    @PostMapping(value={"/v1/process-instances/{processInstanceId}/suspend"}, consumes={"application/json"})
    public EntityModel<CloudProcessInstance> suspend(@Parameter(description="Enter the processInstanceId to suspend") @PathVariable(value="processInstanceId") String var1);

    @PostMapping(value={"/v1/process-instances/{processInstanceId}/resume"}, consumes={"application/json"})
    public EntityModel<CloudProcessInstance> resume(@Parameter(description="Enter the processInstanceId to resume") @PathVariable(value="processInstanceId") String var1);

    @DeleteMapping(value={"/v1/process-instances/{processInstanceId}"})
    public EntityModel<CloudProcessInstance> deleteProcessInstance(@Parameter(description="Enter the processInstanceId to delete") @PathVariable(value="processInstanceId") String var1);

    @PutMapping(value={"/v1/process-instances/{processInstanceId}"}, consumes={"application/json"})
    public EntityModel<CloudProcessInstance> updateProcess(@Parameter(description="Enter the processInstanceId to update") @PathVariable(value="processInstanceId") String var1, @RequestBody UpdateProcessPayload var2);

    @GetMapping(value={"/v1/process-instances/{processInstanceId}/subprocesses"})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public PagedModel<EntityModel<CloudProcessInstance>> subprocesses(@PathVariable(value="processInstanceId") String var1, Pageable var2);
}

