/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.api;

import io.swagger.v3.oas.annotations.Parameter;
import org.activiti.api.task.model.payloads.AssignTaskPayload;
import org.activiti.api.task.model.payloads.AssignTasksPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.cloud.api.task.model.CloudTask;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/admin/v1/tasks"}, produces={"application/hal+json", "application/json"})
public interface TaskAdminController {
    @RequestMapping(method={RequestMethod.GET})
    public PagedModel<EntityModel<CloudTask>> getTasks(Pageable var1);

    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    public EntityModel<CloudTask> getTaskById(@Parameter(description="Enter the taskId to retrieve task by id") @PathVariable String var1);

    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.PUT})
    public EntityModel<CloudTask> updateTask(@Parameter(description="Enter the taskId to update task") @PathVariable(value="taskId") String var1, @RequestBody UpdateTaskPayload var2);

    @RequestMapping(value={"/{taskId}/complete"}, method={RequestMethod.POST})
    public EntityModel<CloudTask> completeTask(@Parameter(description="Enter the taskId to complete task") @PathVariable String var1, @RequestBody(required=false) CompleteTaskPayload var2);

    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.DELETE})
    public EntityModel<CloudTask> deleteTask(@Parameter(description="Enter the taskId to delete task") @PathVariable String var1);

    @RequestMapping(value={"/{taskId}/assign"}, method={RequestMethod.POST})
    public EntityModel<CloudTask> assign(@Parameter(description="Enter the taskId to assign") @PathVariable(value="taskId") String var1, @RequestBody AssignTaskPayload var2);

    @PostMapping(value={"/assign"}, consumes={"application/json"})
    public PagedModel<EntityModel<CloudTask>> assign(@RequestBody AssignTasksPayload var1);
}

