/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.api;

import feign.CollectionFormat;
import io.swagger.v3.oas.annotations.Parameter;
import org.activiti.api.task.model.payloads.AssignTaskPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.CreateTaskPayload;
import org.activiti.api.task.model.payloads.SaveTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.cloud.api.task.model.CloudTask;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface TaskController {
    @GetMapping(value={"/v1/tasks"})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public PagedModel<EntityModel<CloudTask>> getTasks(Pageable var1);

    @GetMapping(value={"/v1/tasks/{taskId}"})
    public EntityModel<CloudTask> getTaskById(@Parameter(description="Enter the taskId to get task") @PathVariable(value="taskId") String var1);

    @PostMapping(value={"/v1/tasks/{taskId}/claim"})
    public EntityModel<CloudTask> claimTask(@Parameter(description="Enter the taskId to claim task") @PathVariable(value="taskId") String var1);

    @PostMapping(value={"/v1/tasks/{taskId}/release"})
    public EntityModel<CloudTask> releaseTask(@Parameter(description="Enter the taskId to release task") @PathVariable(value="taskId") String var1);

    @PostMapping(value={"/v1/tasks/{taskId}/complete"}, consumes={"application/json"})
    public EntityModel<CloudTask> completeTask(@PathVariable(value="taskId") String var1, @RequestBody CompleteTaskPayload var2);

    @PostMapping(value={"/v1/tasks/{taskId}/save"}, consumes={"application/json"})
    public void saveTask(@Parameter(description="Enter the taskId to save task") @PathVariable(value="taskId") String var1, @RequestBody SaveTaskPayload var2);

    @DeleteMapping(value={"/v1/tasks/{taskId}"})
    public EntityModel<CloudTask> deleteTask(@Parameter(description="Enter the taskId to delete task") @PathVariable(value="taskId") String var1);

    @PostMapping(path={"/v1/tasks"}, consumes={"application/json"})
    public EntityModel<CloudTask> createNewTask(@Parameter(description="Enter the taskId to create new task") @RequestBody CreateTaskPayload var1);

    @PutMapping(value={"/v1/tasks/{taskId}"}, consumes={"application/json"})
    public EntityModel<CloudTask> updateTask(@Parameter(description="Enter the taskId to update task") @PathVariable(value="taskId") String var1, @RequestBody UpdateTaskPayload var2);

    @GetMapping(value={"/v1/tasks/{taskId}/subtasks"})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public PagedModel<EntityModel<CloudTask>> getSubtasks(Pageable var1, @Parameter(description="Enter the taskId to get sub tasks") @PathVariable(value="taskId") String var2);

    @PostMapping(value={"/v1/tasks/{taskId}/assign"}, consumes={"application/json"})
    public EntityModel<CloudTask> assign(@Parameter(description="Enter the taskId to assign task pay load") @PathVariable(value="taskId") String var1, @RequestBody AssignTaskPayload var2);
}

