/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.api;

import feign.CollectionFormat;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import java.util.Map;
import org.activiti.cloud.api.process.model.CloudProcessDefinition;
import org.activiti.cloud.api.process.model.ExtendedCloudProcessDefinition;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public interface ProcessDefinitionController {
    @GetMapping(value={"/v1/process-definitions"})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public PagedModel<EntityModel<ExtendedCloudProcessDefinition>> getProcessDefinitions(@Parameter(description="List of values to include in response") @RequestParam(value="include", required=false) List<String> var1, Pageable var2);

    @GetMapping(value={"/v1/process-definitions/{id}"})
    public EntityModel<CloudProcessDefinition> getProcessDefinition(@Parameter(description="Enter the id to get process definition") @PathVariable(value="id") String var1);

    @GetMapping(value={"/v1/process-definitions/{id}/model"}, produces={"application/xml"})
    @ResponseBody
    public String getProcessModel(@Parameter(description="Enter the id to get process model") @PathVariable(value="id") String var1);

    @GetMapping(value={"/v1/process-definitions/{id}/model"}, produces={"application/json"})
    @ResponseBody
    public String getBpmnModel(@Parameter(description="Enter the id to get Bpmn model") @PathVariable(value="id") String var1);

    @GetMapping(value={"/v1/process-definitions/{id}/model"}, produces={"image/svg+xml"})
    @ResponseBody
    public String getProcessDiagram(@Parameter(description="Enter the id to get process diagram") @PathVariable(value="id") String var1);

    @GetMapping(value={"/v1/process-definitions/{id}/static-values"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getProcessModelStaticValuesMappingForStartEvent(@Parameter(description="Enter the id to get process model static values mapping for start event") @PathVariable(value="id") String var1);

    @GetMapping(value={"/v1/process-definitions/{id}/constant-values"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getProcessModelConstantValuesForStartEvent(@Parameter(description="Enter the id to get process model constant values for start event") @PathVariable(value="id") String var1);
}

