/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.rest.api;

import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import org.activiti.cloud.api.process.model.ExtendedCloudProcessDefinition;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(
    value = "/admin/v1/process-definitions",
    produces = { MediaTypes.HAL_JSON_VALUE, MediaType.APPLICATION_JSON_VALUE }
)
public interface ProcessDefinitionAdminController {
    @RequestMapping(method = RequestMethod.GET)
    PagedModel<EntityModel<ExtendedCloudProcessDefinition>> getAllProcessDefinitions(
        @Parameter(description = "List of values to include in response") @RequestParam(
            value = "include",
            required = false
        ) List<String> include,
        @Parameter(
            description = "Specifies whether to include latest versions only (true) or all the versions (false) of each process definition"
        ) @RequestParam(value = "latestVersion", required = false, defaultValue = "false") boolean latestVersion,
        Pageable pageable
    );
}
