/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.task.model.payloads.CandidateUsersPayload;
import org.activiti.api.task.runtime.TaskRuntime;
import org.activiti.cloud.api.process.model.impl.CandidateUser;
import org.activiti.cloud.services.rest.api.CandidateUserController;
import org.activiti.cloud.services.rest.assemblers.CollectionModelAssembler;
import org.activiti.cloud.services.rest.assemblers.ToCandidateUserConverter;
import org.activiti.cloud.services.rest.assemblers.UserCandidatesRepresentationModelAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CandidateUserControllerImpl
implements CandidateUserController {
    private final TaskRuntime taskRuntime;
    private final UserCandidatesRepresentationModelAssembler userCandidatesRepresentationModelAssembler;
    private final CollectionModelAssembler resourcesAssembler;
    private final ToCandidateUserConverter toCandidateUserConverter;

    public CandidateUserControllerImpl(TaskRuntime taskRuntime, UserCandidatesRepresentationModelAssembler userCandidatesRepresentationModelAssembler, CollectionModelAssembler resourcesAssembler, ToCandidateUserConverter toCandidateUserConverter) {
        this.taskRuntime = taskRuntime;
        this.userCandidatesRepresentationModelAssembler = userCandidatesRepresentationModelAssembler;
        this.resourcesAssembler = resourcesAssembler;
        this.toCandidateUserConverter = toCandidateUserConverter;
    }

    public void addCandidateUsers(@PathVariable String taskId, @RequestBody CandidateUsersPayload candidateUsersPayload) {
        if (candidateUsersPayload != null) {
            candidateUsersPayload.setTaskId(taskId);
        }
        this.taskRuntime.addCandidateUsers(candidateUsersPayload);
    }

    public void deleteCandidateUsers(@PathVariable String taskId, @RequestBody CandidateUsersPayload candidateUsersPayload) {
        if (candidateUsersPayload != null) {
            candidateUsersPayload.setTaskId(taskId);
        }
        this.taskRuntime.deleteCandidateUsers(candidateUsersPayload);
    }

    public CollectionModel<EntityModel<CandidateUser>> getUserCandidates(@PathVariable String taskId) {
        this.userCandidatesRepresentationModelAssembler.setTaskId(taskId);
        return this.resourcesAssembler.toCollectionModel(this.toCandidateUserConverter.from(this.taskRuntime.userCandidates(taskId)), this.userCandidatesRepresentationModelAssembler, WebMvcLinkBuilder.linkTo(((CandidateUserControllerImpl)WebMvcLinkBuilder.methodOn(this.getClass(), (Object[])new Object[0])).getUserCandidates(this.userCandidatesRepresentationModelAssembler.getTaskId())).withSelfRel());
    }
}

