/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.task.model.payloads.CandidateGroupsPayload;
import org.activiti.api.task.runtime.TaskAdminRuntime;
import org.activiti.cloud.api.process.model.impl.CandidateGroup;
import org.activiti.cloud.services.rest.api.CandidateGroupAdminController;
import org.activiti.cloud.services.rest.assemblers.CollectionModelAssembler;
import org.activiti.cloud.services.rest.assemblers.GroupCandidatesRepresentationModelAssembler;
import org.activiti.cloud.services.rest.assemblers.ToCandidateGroupConverter;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CandidateGroupAdminControllerImpl
implements CandidateGroupAdminController {
    private final TaskAdminRuntime taskAdminRuntime;
    private final CollectionModelAssembler resourcesAssembler;
    private final GroupCandidatesRepresentationModelAssembler groupCandidatesRepresentationModelAssembler;
    private final ToCandidateGroupConverter toCandidateGroupConverter;

    public CandidateGroupAdminControllerImpl(TaskAdminRuntime taskAdminRuntime, GroupCandidatesRepresentationModelAssembler groupCandidatesRepresentationModelAssembler, ToCandidateGroupConverter toCandidateGroupConverter, CollectionModelAssembler resourcesAssembler) {
        this.taskAdminRuntime = taskAdminRuntime;
        this.groupCandidatesRepresentationModelAssembler = groupCandidatesRepresentationModelAssembler;
        this.toCandidateGroupConverter = toCandidateGroupConverter;
        this.resourcesAssembler = resourcesAssembler;
    }

    public void addCandidateGroups(@PathVariable String taskId, @RequestBody CandidateGroupsPayload candidateGroupsPayload) {
        if (candidateGroupsPayload != null) {
            candidateGroupsPayload.setTaskId(taskId);
        }
        this.taskAdminRuntime.addCandidateGroups(candidateGroupsPayload);
    }

    public void deleteCandidateGroups(@PathVariable String taskId, @RequestBody CandidateGroupsPayload candidateGroupsPayload) {
        if (candidateGroupsPayload != null) {
            candidateGroupsPayload.setTaskId(taskId);
        }
        this.taskAdminRuntime.deleteCandidateGroups(candidateGroupsPayload);
    }

    public CollectionModel<EntityModel<CandidateGroup>> getGroupCandidates(@PathVariable String taskId) {
        this.groupCandidatesRepresentationModelAssembler.setTaskId(taskId);
        return this.resourcesAssembler.toCollectionModel(this.toCandidateGroupConverter.from(this.taskAdminRuntime.groupCandidates(taskId)), this.groupCandidatesRepresentationModelAssembler, WebMvcLinkBuilder.linkTo(((CandidateGroupAdminControllerImpl)WebMvcLinkBuilder.methodOn(this.getClass(), (Object[])new Object[0])).getGroupCandidates(this.groupCandidatesRepresentationModelAssembler.getTaskId())).withSelfRel());
    }
}

