/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.builders.ProcessPayloadBuilder;
import org.activiti.api.process.model.payloads.ReceiveMessagePayload;
import org.activiti.api.process.model.payloads.StartMessagePayload;
import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.api.process.model.payloads.UpdateProcessPayload;
import org.activiti.api.process.runtime.ProcessAdminRuntime;
import org.activiti.api.runtime.shared.NotFoundException;
import org.activiti.api.runtime.shared.query.Page;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.CloudProcessInstance;
import org.activiti.cloud.services.core.ProcessVariablesPayloadConverter;
import org.activiti.cloud.services.core.pageable.SpringPageConverter;
import org.activiti.cloud.services.events.services.CloudProcessDeletedService;
import org.activiti.cloud.services.rest.api.ProcessInstanceAdminController;
import org.activiti.cloud.services.rest.assemblers.ProcessInstanceRepresentationModelAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceAdminControllerImpl
implements ProcessInstanceAdminController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceAdminControllerImpl.class);
    private final Set<ProcessInstance.ProcessInstanceStatus> deleteStatuses = Set.of(ProcessInstance.ProcessInstanceStatus.COMPLETED, ProcessInstance.ProcessInstanceStatus.CANCELLED);
    private final String DELETE_PROCESS_NOT_ALLOWED = "Process Instance %s is not in status: " + String.join((CharSequence)", ", this.deleteStatuses.stream().map(Enum::name).collect(Collectors.toList()));
    private final ProcessInstanceRepresentationModelAssembler representationModelAssembler;
    private final AlfrescoPagedModelAssembler<ProcessInstance> pagedCollectionModelAssembler;
    private final ProcessAdminRuntime processAdminRuntime;
    private final SpringPageConverter pageConverter;
    private final ProcessVariablesPayloadConverter variablesPayloadConverter;
    private final CloudProcessDeletedService cloudProcessDeletedService;

    public ProcessInstanceAdminControllerImpl(ProcessInstanceRepresentationModelAssembler representationModelAssembler, AlfrescoPagedModelAssembler<ProcessInstance> pagedCollectionModelAssembler, ProcessAdminRuntime processAdminRuntime, SpringPageConverter pageConverter, ProcessVariablesPayloadConverter variablesPayloadConverter, CloudProcessDeletedService cloudProcessDeletedService) {
        this.representationModelAssembler = representationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.processAdminRuntime = processAdminRuntime;
        this.pageConverter = pageConverter;
        this.variablesPayloadConverter = variablesPayloadConverter;
        this.cloudProcessDeletedService = cloudProcessDeletedService;
    }

    public PagedModel<EntityModel<CloudProcessInstance>> getProcessInstances(Pageable pageable) {
        Page processInstancePage = this.processAdminRuntime.processInstances(this.pageConverter.toAPIPageable(pageable));
        return this.pagedCollectionModelAssembler.toModel(pageable, this.pageConverter.toSpringPage(pageable, processInstancePage), (RepresentationModelAssembler)this.representationModelAssembler);
    }

    public EntityModel<CloudProcessInstance> startProcess(@RequestBody StartProcessPayload startProcessPayload) {
        StartProcessPayload convertedStartProcessPayload = this.variablesPayloadConverter.convert(startProcessPayload);
        return this.representationModelAssembler.toModel(this.processAdminRuntime.start(convertedStartProcessPayload));
    }

    public EntityModel<CloudProcessInstance> getProcessInstanceById(@PathVariable String processInstanceId) {
        return this.representationModelAssembler.toModel(this.processAdminRuntime.processInstance(processInstanceId));
    }

    public EntityModel<CloudProcessInstance> resume(@PathVariable String processInstanceId) {
        return this.representationModelAssembler.toModel(this.processAdminRuntime.resume(ProcessPayloadBuilder.resume((String)processInstanceId)));
    }

    public EntityModel<CloudProcessInstance> suspend(@PathVariable String processInstanceId) {
        return this.representationModelAssembler.toModel(this.processAdminRuntime.suspend(ProcessPayloadBuilder.suspend((String)processInstanceId)));
    }

    public EntityModel<CloudProcessInstance> deleteProcessInstance(@PathVariable String processInstanceId) {
        return this.representationModelAssembler.toModel(this.processAdminRuntime.delete(ProcessPayloadBuilder.delete((String)processInstanceId)));
    }

    public ResponseEntity<Void> destroyProcessInstance(@PathVariable String processInstanceId, boolean force) {
        try {
            ProcessInstance processInstance = this.processAdminRuntime.processInstance(processInstanceId);
            if (processInstance != null && !this.deleteStatuses.contains(processInstance.getStatus())) {
                if (force) {
                    this.cloudProcessDeletedService.delete(processInstanceId);
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).build();
                }
                throw new IllegalStateException(String.format(this.DELETE_PROCESS_NOT_ALLOWED, processInstanceId));
            }
        }
        catch (NotFoundException e) {
            LOGGER.debug("Process Instance " + processInstanceId + " not found. Sending PROCESS_DELETE event.");
        }
        this.cloudProcessDeletedService.sendDeleteEvent(processInstanceId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    public EntityModel<CloudProcessInstance> updateProcess(@PathVariable String processInstanceId, @RequestBody UpdateProcessPayload payload) {
        if (payload != null) {
            payload.setProcessInstanceId(processInstanceId);
        }
        return this.representationModelAssembler.toModel(this.processAdminRuntime.update(payload));
    }

    public PagedModel<EntityModel<CloudProcessInstance>> subprocesses(@PathVariable String processInstanceId, Pageable pageable) {
        Page processInstancePage = this.processAdminRuntime.processInstances(this.pageConverter.toAPIPageable(pageable), ProcessPayloadBuilder.subprocesses((String)processInstanceId));
        return this.pagedCollectionModelAssembler.toModel(pageable, this.pageConverter.toSpringPage(pageable, processInstancePage), (RepresentationModelAssembler)this.representationModelAssembler);
    }

    public EntityModel<CloudProcessInstance> start(@RequestBody StartMessagePayload startMessagePayload) {
        startMessagePayload = this.variablesPayloadConverter.convert(startMessagePayload);
        ProcessInstance processInstance = this.processAdminRuntime.start(startMessagePayload);
        return this.representationModelAssembler.toModel(processInstance);
    }

    public ResponseEntity<Void> receive(@RequestBody ReceiveMessagePayload receiveMessagePayload) {
        this.processAdminRuntime.receive(receiveMessagePayload);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

