/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.process.model.builders.ProcessPayloadBuilder;
import org.activiti.api.process.model.payloads.RemoveProcessVariablesPayload;
import org.activiti.api.process.model.payloads.SetProcessVariablesPayload;
import org.activiti.api.process.runtime.ProcessAdminRuntime;
import org.activiti.cloud.api.model.shared.CloudVariableInstance;
import org.activiti.cloud.services.rest.api.ProcessInstanceVariableAdminController;
import org.activiti.cloud.services.rest.assemblers.CollectionModelAssembler;
import org.activiti.cloud.services.rest.assemblers.ProcessInstanceVariableRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstanceVariableAdminControllerImpl
implements ProcessInstanceVariableAdminController {
    private final ProcessInstanceVariableRepresentationModelAssembler variableRepresentationModelAssembler;
    private final ProcessAdminRuntime processAdminRuntime;
    private final CollectionModelAssembler resourcesAssembler;

    @Autowired
    public ProcessInstanceVariableAdminControllerImpl(ProcessInstanceVariableRepresentationModelAssembler variableRepresentationModelAssembler, ProcessAdminRuntime processAdminRuntime, CollectionModelAssembler resourcesAssembler) {
        this.variableRepresentationModelAssembler = variableRepresentationModelAssembler;
        this.processAdminRuntime = processAdminRuntime;
        this.resourcesAssembler = resourcesAssembler;
    }

    public CollectionModel<EntityModel<CloudVariableInstance>> getVariables(String processInstanceId) {
        return this.resourcesAssembler.toCollectionModel(this.processAdminRuntime.variables(ProcessPayloadBuilder.variables().withProcessInstanceId(processInstanceId).build()), this.variableRepresentationModelAssembler, new Link[0]);
    }

    public ResponseEntity<Void> updateVariables(@PathVariable String processInstanceId, @RequestBody SetProcessVariablesPayload setProcessVariablesPayload) {
        if (setProcessVariablesPayload != null) {
            setProcessVariablesPayload.setProcessInstanceId(processInstanceId);
        }
        this.processAdminRuntime.setVariables(setProcessVariablesPayload);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<Void> removeVariables(@PathVariable String processInstanceId, @RequestBody RemoveProcessVariablesPayload removeProcessVariablesPayload) {
        if (removeProcessVariablesPayload != null) {
            removeProcessVariablesPayload.setProcessInstanceId(processInstanceId);
        }
        this.processAdminRuntime.removeVariables(removeProcessVariablesPayload);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

