/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.runtime.shared.query.Page;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.builders.TaskPayloadBuilder;
import org.activiti.api.task.model.payloads.AssignTaskPayload;
import org.activiti.api.task.model.payloads.CompleteTaskPayload;
import org.activiti.api.task.model.payloads.CreateTaskPayload;
import org.activiti.api.task.model.payloads.SaveTaskPayload;
import org.activiti.api.task.model.payloads.UpdateTaskPayload;
import org.activiti.api.task.runtime.TaskRuntime;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.task.model.CloudTask;
import org.activiti.cloud.services.core.ProcessVariablesPayloadConverter;
import org.activiti.cloud.services.core.pageable.SpringPageConverter;
import org.activiti.cloud.services.rest.api.TaskController;
import org.activiti.cloud.services.rest.assemblers.TaskRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(produces={"application/hal+json", "application/json"})
public class TaskControllerImpl
implements TaskController {
    private final TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private final AlfrescoPagedModelAssembler<Task> pagedCollectionModelAssembler;
    private final SpringPageConverter pageConverter;
    private final TaskRuntime taskRuntime;
    private final ProcessVariablesPayloadConverter payloadConverter;

    @Autowired
    public TaskControllerImpl(TaskRepresentationModelAssembler taskRepresentationModelAssembler, AlfrescoPagedModelAssembler<Task> pagedCollectionModelAssembler, SpringPageConverter pageConverter, TaskRuntime taskRuntime, ProcessVariablesPayloadConverter payloadConverter) {
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.pageConverter = pageConverter;
        this.taskRuntime = taskRuntime;
        this.payloadConverter = payloadConverter;
    }

    public PagedModel<EntityModel<CloudTask>> getTasks(Pageable pageable) {
        Page taskPage = this.taskRuntime.tasks(this.pageConverter.toAPIPageable(pageable));
        return this.pagedCollectionModelAssembler.toModel(pageable, this.pageConverter.toSpringPage(pageable, taskPage), (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }

    public EntityModel<CloudTask> getTaskById(@PathVariable String taskId) {
        Task task = this.taskRuntime.task(taskId);
        return this.taskRepresentationModelAssembler.toModel(task);
    }

    public EntityModel<CloudTask> claimTask(@PathVariable String taskId) {
        return this.taskRepresentationModelAssembler.toModel(this.taskRuntime.claim(TaskPayloadBuilder.claim().withTaskId(taskId).build()));
    }

    public EntityModel<CloudTask> releaseTask(@PathVariable String taskId) {
        return this.taskRepresentationModelAssembler.toModel(this.taskRuntime.release(TaskPayloadBuilder.release().withTaskId(taskId).build()));
    }

    public EntityModel<CloudTask> completeTask(@PathVariable String taskId, @RequestBody(required=false) CompleteTaskPayload completeTaskPayload) {
        if (completeTaskPayload == null) {
            completeTaskPayload = TaskPayloadBuilder.complete().withTaskId(taskId).build();
        } else {
            completeTaskPayload.setTaskId(taskId);
            completeTaskPayload = this.payloadConverter.convert(completeTaskPayload);
        }
        Task task = this.taskRuntime.complete(completeTaskPayload);
        return this.taskRepresentationModelAssembler.toModel(task);
    }

    public EntityModel<CloudTask> deleteTask(@PathVariable String taskId) {
        Task task = this.taskRuntime.delete(TaskPayloadBuilder.delete().withTaskId(taskId).build());
        return this.taskRepresentationModelAssembler.toModel(task);
    }

    public EntityModel<CloudTask> createNewTask(@RequestBody CreateTaskPayload createTaskPayload) {
        return this.taskRepresentationModelAssembler.toModel(this.taskRuntime.create(createTaskPayload));
    }

    public EntityModel<CloudTask> updateTask(@PathVariable String taskId, @RequestBody UpdateTaskPayload updateTaskPayload) {
        if (updateTaskPayload != null) {
            updateTaskPayload.setTaskId(taskId);
        }
        return this.taskRepresentationModelAssembler.toModel(this.taskRuntime.update(updateTaskPayload));
    }

    public PagedModel<EntityModel<CloudTask>> getSubtasks(Pageable pageable, @PathVariable String taskId) {
        Page taskPage = this.taskRuntime.tasks(this.pageConverter.toAPIPageable(pageable), TaskPayloadBuilder.tasks().withParentTaskId(taskId).build());
        return this.pagedCollectionModelAssembler.toModel(pageable, this.pageConverter.toSpringPage(pageable, taskPage), (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }

    public void saveTask(@PathVariable String taskId, @RequestBody SaveTaskPayload saveTaskPayload) {
        if (saveTaskPayload != null) {
            saveTaskPayload.setTaskId(taskId);
        }
        this.taskRuntime.save(this.payloadConverter.convert(saveTaskPayload));
    }

    public EntityModel<CloudTask> assign(@PathVariable String taskId, @RequestBody AssignTaskPayload assignTaskPayload) {
        if (assignTaskPayload != null) {
            assignTaskPayload.setTaskId(taskId);
        }
        return this.taskRepresentationModelAssembler.toModel(this.taskRuntime.assign(assignTaskPayload));
    }
}

