/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.task.model.builders.TaskPayloadBuilder;
import org.activiti.api.task.model.payloads.CreateTaskVariablePayload;
import org.activiti.api.task.model.payloads.UpdateTaskVariablePayload;
import org.activiti.api.task.runtime.TaskRuntime;
import org.activiti.cloud.api.model.shared.CloudVariableInstance;
import org.activiti.cloud.services.rest.api.TaskVariableController;
import org.activiti.cloud.services.rest.assemblers.CollectionModelAssembler;
import org.activiti.cloud.services.rest.assemblers.TaskVariableInstanceRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(produces={"application/hal+json", "application/json"})
public class TaskVariableControllerImpl
implements TaskVariableController {
    private final TaskVariableInstanceRepresentationModelAssembler variableRepresentationModelAssembler;
    private final CollectionModelAssembler resourcesAssembler;
    private final TaskRuntime taskRuntime;

    @Autowired
    public TaskVariableControllerImpl(TaskVariableInstanceRepresentationModelAssembler variableRepresentationModelAssembler, CollectionModelAssembler resourcesAssembler, TaskRuntime taskRuntime) {
        this.variableRepresentationModelAssembler = variableRepresentationModelAssembler;
        this.resourcesAssembler = resourcesAssembler;
        this.taskRuntime = taskRuntime;
    }

    public CollectionModel<EntityModel<CloudVariableInstance>> getVariables(@PathVariable String taskId) {
        return this.resourcesAssembler.toCollectionModel(this.taskRuntime.variables(TaskPayloadBuilder.variables().withTaskId(taskId).build()), this.variableRepresentationModelAssembler, new Link[0]);
    }

    public ResponseEntity<Void> createVariable(@PathVariable String taskId, @RequestBody CreateTaskVariablePayload createTaskVariablePayload) {
        createTaskVariablePayload.setTaskId(taskId);
        this.taskRuntime.createVariable(createTaskVariablePayload);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<Void> updateVariable(@PathVariable String taskId, @PathVariable String variableName, @RequestBody UpdateTaskVariablePayload updateTaskVariablePayload) {
        updateTaskVariablePayload.setTaskId(taskId);
        updateTaskVariablePayload.setName(variableName);
        this.taskRuntime.updateVariable(updateTaskVariablePayload);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

