/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.assemblers;

import java.util.ArrayList;
import org.activiti.api.task.model.Task;
import org.activiti.cloud.api.task.model.CloudTask;
import org.activiti.cloud.services.rest.assemblers.ToCloudTaskConverter;
import org.activiti.cloud.services.rest.controllers.HomeControllerImpl;
import org.activiti.cloud.services.rest.controllers.ProcessInstanceControllerImpl;
import org.activiti.cloud.services.rest.controllers.TaskControllerImpl;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class TaskRepresentationModelAssembler
implements RepresentationModelAssembler<Task, EntityModel<CloudTask>> {
    private ToCloudTaskConverter converter;

    public TaskRepresentationModelAssembler(ToCloudTaskConverter converter) {
        this.converter = converter;
    }

    public EntityModel<CloudTask> toModel(Task task) {
        CloudTask cloudTask = this.converter.from(task);
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(WebMvcLinkBuilder.linkTo(((TaskControllerImpl)WebMvcLinkBuilder.methodOn(TaskControllerImpl.class, (Object[])new Object[0])).getTaskById(cloudTask.getId())).withSelfRel());
        if (Task.TaskStatus.ASSIGNED != cloudTask.getStatus()) {
            links.add(WebMvcLinkBuilder.linkTo(((TaskControllerImpl)WebMvcLinkBuilder.methodOn(TaskControllerImpl.class, (Object[])new Object[0])).claimTask(cloudTask.getId())).withRel("claim"));
        } else {
            links.add(WebMvcLinkBuilder.linkTo(((TaskControllerImpl)WebMvcLinkBuilder.methodOn(TaskControllerImpl.class, (Object[])new Object[0])).releaseTask(cloudTask.getId())).withRel("release"));
            links.add(WebMvcLinkBuilder.linkTo(((TaskControllerImpl)WebMvcLinkBuilder.methodOn(TaskControllerImpl.class, (Object[])new Object[0])).completeTask(cloudTask.getId(), null)).withRel("complete"));
        }
        if (cloudTask.getProcessInstanceId() != null && !cloudTask.getProcessInstanceId().isEmpty()) {
            links.add(WebMvcLinkBuilder.linkTo(((ProcessInstanceControllerImpl)WebMvcLinkBuilder.methodOn(ProcessInstanceControllerImpl.class, (Object[])new Object[0])).getProcessInstanceById(cloudTask.getProcessInstanceId())).withRel("processInstance"));
        }
        if (cloudTask.getParentTaskId() != null && !cloudTask.getParentTaskId().isEmpty()) {
            links.add(WebMvcLinkBuilder.linkTo(((TaskControllerImpl)WebMvcLinkBuilder.methodOn(TaskControllerImpl.class, (Object[])new Object[0])).getTaskById(cloudTask.getParentTaskId())).withRel("parent"));
        }
        links.add(WebMvcLinkBuilder.linkTo(HomeControllerImpl.class).withRel("home"));
        return EntityModel.of((Object)cloudTask, links);
    }
}

