/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.builders.ProcessPayloadBuilder;
import org.activiti.api.process.model.payloads.CreateProcessInstancePayload;
import org.activiti.api.process.model.payloads.ReceiveMessagePayload;
import org.activiti.api.process.model.payloads.SignalPayload;
import org.activiti.api.process.model.payloads.StartMessagePayload;
import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.api.process.model.payloads.UpdateProcessPayload;
import org.activiti.api.process.runtime.ProcessRuntime;
import org.activiti.api.runtime.shared.query.Page;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.CloudProcessInstance;
import org.activiti.cloud.services.core.ProcessDiagramGeneratorWrapper;
import org.activiti.cloud.services.core.ProcessVariablesPayloadConverter;
import org.activiti.cloud.services.core.pageable.SpringPageConverter;
import org.activiti.cloud.services.rest.api.ProcessInstanceController;
import org.activiti.cloud.services.rest.assemblers.ProcessInstanceRepresentationModelAssembler;
import org.activiti.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(produces={"application/hal+json", "application/json"})
public class ProcessInstanceControllerImpl
implements ProcessInstanceController {
    private final RepositoryService repositoryService;
    private final ProcessDiagramGeneratorWrapper processDiagramGenerator;
    private final ProcessInstanceRepresentationModelAssembler representationModelAssembler;
    private final AlfrescoPagedModelAssembler<ProcessInstance> pagedCollectionModelAssembler;
    private final ProcessRuntime processRuntime;
    private final SpringPageConverter pageConverter;
    private final ProcessVariablesPayloadConverter variablesPayloadConverter;

    @Autowired
    public ProcessInstanceControllerImpl(RepositoryService repositoryService, ProcessDiagramGeneratorWrapper processDiagramGenerator, ProcessInstanceRepresentationModelAssembler representationModelAssembler, AlfrescoPagedModelAssembler<ProcessInstance> pagedCollectionModelAssembler, ProcessRuntime processRuntime, SpringPageConverter pageConverter, ProcessVariablesPayloadConverter variablesPayloadConverter) {
        this.repositoryService = repositoryService;
        this.processDiagramGenerator = processDiagramGenerator;
        this.representationModelAssembler = representationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.processRuntime = processRuntime;
        this.pageConverter = pageConverter;
        this.variablesPayloadConverter = variablesPayloadConverter;
    }

    public PagedModel<EntityModel<CloudProcessInstance>> getProcessInstances(Pageable pageable) {
        Page processInstancePage = this.processRuntime.processInstances(this.pageConverter.toAPIPageable(pageable));
        return this.pagedCollectionModelAssembler.toModel(pageable, this.pageConverter.toSpringPage(pageable, processInstancePage), (RepresentationModelAssembler)this.representationModelAssembler);
    }

    public EntityModel<CloudProcessInstance> startProcess(@RequestBody StartProcessPayload startProcessPayload) {
        startProcessPayload = this.variablesPayloadConverter.convert(startProcessPayload);
        return this.representationModelAssembler.toModel(this.processRuntime.start(startProcessPayload));
    }

    public EntityModel<CloudProcessInstance> startCreatedProcess(@PathVariable String processInstanceId, @RequestBody(required=false) StartProcessPayload startProcessPayload) {
        StartProcessPayload convertedStartProcessPayload = this.variablesPayloadConverter.convert(Optional.ofNullable(startProcessPayload).orElse(ProcessPayloadBuilder.start().build()));
        return this.representationModelAssembler.toModel(this.processRuntime.startCreatedProcess(processInstanceId, convertedStartProcessPayload));
    }

    public EntityModel<CloudProcessInstance> createProcessInstance(@RequestBody CreateProcessInstancePayload createProcessInstancePayload) {
        return this.representationModelAssembler.toModel(this.processRuntime.create(createProcessInstancePayload));
    }

    public EntityModel<CloudProcessInstance> getProcessInstanceById(@PathVariable String processInstanceId) {
        return this.representationModelAssembler.toModel(this.processRuntime.processInstance(processInstanceId));
    }

    public String getProcessDiagram(@PathVariable String processInstanceId) {
        ProcessInstance processInstance = this.processRuntime.processInstance(processInstanceId);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        return new String(this.processDiagramGenerator.generateDiagram(bpmnModel, this.processRuntime.processInstanceMeta(processInstance.getId()).getActiveActivitiesIds(), Collections.emptyList(), Collections.emptyList()), StandardCharsets.UTF_8);
    }

    public ResponseEntity<Void> sendSignal(@RequestBody SignalPayload cmd) {
        this.processRuntime.signal(cmd);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    public EntityModel<CloudProcessInstance> suspend(@PathVariable String processInstanceId) {
        return this.representationModelAssembler.toModel(this.processRuntime.suspend(ProcessPayloadBuilder.suspend((String)processInstanceId)));
    }

    public EntityModel<CloudProcessInstance> resume(@PathVariable String processInstanceId) {
        return this.representationModelAssembler.toModel(this.processRuntime.resume(ProcessPayloadBuilder.resume((String)processInstanceId)));
    }

    public EntityModel<CloudProcessInstance> deleteProcessInstance(@PathVariable String processInstanceId) {
        return this.representationModelAssembler.toModel(this.processRuntime.delete(ProcessPayloadBuilder.delete((String)processInstanceId)));
    }

    public EntityModel<CloudProcessInstance> updateProcess(@PathVariable String processInstanceId, @RequestBody UpdateProcessPayload payload) {
        if (payload != null) {
            payload.setProcessInstanceId(processInstanceId);
        }
        return this.representationModelAssembler.toModel(this.processRuntime.update(payload));
    }

    public PagedModel<EntityModel<CloudProcessInstance>> subprocesses(@PathVariable String processInstanceId, Pageable pageable) {
        Page processInstancePage = this.processRuntime.processInstances(this.pageConverter.toAPIPageable(pageable), ProcessPayloadBuilder.subprocesses((String)processInstanceId));
        return this.pagedCollectionModelAssembler.toModel(pageable, this.pageConverter.toSpringPage(pageable, processInstancePage), (RepresentationModelAssembler)this.representationModelAssembler);
    }

    public EntityModel<CloudProcessInstance> sendStartMessage(@RequestBody StartMessagePayload startMessagePayload) {
        startMessagePayload = this.variablesPayloadConverter.convert(startMessagePayload);
        ProcessInstance processInstance = this.processRuntime.start(startMessagePayload);
        return this.representationModelAssembler.toModel(processInstance);
    }

    public ResponseEntity<Void> receive(@RequestBody ReceiveMessagePayload receiveMessagePayload) {
        this.processRuntime.receive(receiveMessagePayload);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

