/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.gateway.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.activiti.api.model.shared.Result;
import org.activiti.cloud.common.messaging.config.FunctionBindingConfiguration;
import org.activiti.cloud.common.messaging.functional.FunctionBinding;
import org.activiti.cloud.services.gateway.ProcessRuntimeGateway;
import org.activiti.cloud.services.gateway.channels.ProcessRuntimeGatewayChannelsConfiguration;
import org.activiti.cloud.services.gateway.config.ProcessRuntimeGatewayProperties;
import org.aopalliance.aop.Advice;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.integration.config.IntegrationConverter;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.handler.advice.RequestHandlerRetryAdvice;
import org.springframework.integration.support.channel.HeaderChannelRegistry;
import org.springframework.integration.support.json.Jackson2JsonObjectMapper;
import org.springframework.messaging.Message;

@AutoConfiguration
@EnableConfigurationProperties(value={ProcessRuntimeGatewayProperties.class})
@PropertySource(value={"classpath:process-runtime-gateway.properties"})
@Import(value={ProcessRuntimeGatewayChannelsConfiguration.class})
public class ProcessRuntimeGatewayAutoConfiguration {
    public static final String PROCESS_RUNTIME_GATEWAY_BEAN_NAME = "processRuntimeGateway";
    public static final String PROCESS_RUNTIME_GATEWAY_RESULT_CHANNEL_NAME = "processRuntimeGatewayResultChannelName";
    public static final String PROCESS_RUNTIME_GATEWAY_RESULTS_FLOW_INPUT = "processRuntimeGatewayResultsFlowInput";

    @Bean
    IntegrationFlow processRuntimeGatewayProducerFlow(ProcessRuntimeGatewayProperties properties, StreamBridge streamBridge, BindingServiceProperties bindingServiceProperties, HeaderChannelRegistry headerChannelRegistry, FunctionBindingConfiguration.BindingResolver bindingResolver) {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from(ProcessRuntimeGateway.class, gatewayProxySpec -> gatewayProxySpec.beanName(PROCESS_RUNTIME_GATEWAY_BEAN_NAME).replyTimeout(properties.getReplyTimeout().toMillis())).enrichHeaders(headerEnricherSpec -> headerEnricherSpec.headerChannelsToString().headerFunction(PROCESS_RUNTIME_GATEWAY_RESULT_CHANNEL_NAME, message -> headerChannelRegistry.channelToChannelName(message.getHeaders().getReplyChannel())))).handle(message -> streamBridge.send(bindingResolver.getBindingDestination("ProcessRuntimeGatewayProducer"), (Object)message), messageHandlerSpec -> messageHandlerSpec.advice(new Advice[]{new RequestHandlerRetryAdvice()}))).get();
    }

    @FunctionBinding(input="ProcessRuntimeGatewayResults")
    @Bean
    Consumer<Message<?>> processRuntimeGatewayResultsConsumer(IntegrationFlow processRuntimeGatewayResultsFlow) {
        return message -> processRuntimeGatewayResultsFlow.getInputChannel().send(message);
    }

    @Bean
    IntegrationFlow processRuntimeGatewayResultsFlow(HeaderChannelRegistry headerChannelRegistry) {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((String)PROCESS_RUNTIME_GATEWAY_RESULTS_FLOW_INPUT).filter(Message.class, message -> Optional.ofNullable((String)message.getHeaders().get((Object)PROCESS_RUNTIME_GATEWAY_RESULT_CHANNEL_NAME, String.class)).map(arg_0 -> ((HeaderChannelRegistry)headerChannelRegistry).channelNameToChannel(arg_0)).isPresent())).route(Message.class, message -> message.getHeaders().get((Object)PROCESS_RUNTIME_GATEWAY_RESULT_CHANNEL_NAME))).get();
    }

    @IntegrationConverter
    @Bean
    ConditionalGenericConverter processRuntimeGatewayResultConverter(ObjectMapper objectMapper) {
        final Jackson2JsonObjectMapper jackson2JsonObjectMapper = new Jackson2JsonObjectMapper(objectMapper);
        return new ConditionalGenericConverter(){

            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                return Result.class.isAssignableFrom(targetType.getObjectType()) && sourceType.getType() == byte[].class;
            }

            public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                return null;
            }

            public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
                try {
                    return jackson2JsonObjectMapper.fromJson(source, targetType.getType());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

