/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.gateway.config;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties("activiti.cloud.process-runtime-gateway")
public class ProcessRuntimeGatewayProperties {

    private boolean enabled;

    @NotEmpty
    private String group;

    @NotNull
    private Duration replyTimeout = Duration.ofSeconds(30);

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public @NotEmpty String getGroup() {
        return group;
    }

    public void setGroup(@NotEmpty String group) {
        this.group = group;
    }

    public @NotNull Duration getReplyTimeout() {
        return replyTimeout;
    }

    public void setReplyTimeout(@NotNull Duration replyTimeout) {
        this.replyTimeout = replyTimeout;
    }
}
