/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.subscription.channel;

import java.util.function.Consumer;
import org.activiti.api.process.model.payloads.SignalPayload;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.RuntimeService;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class BroadcastSignalEventHandler
implements Consumer<SignalPayload> {
    private final RuntimeService runtimeService;

    public BroadcastSignalEventHandler(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Override
    @Retryable(value={ActivitiOptimisticLockingException.class}, maxAttemptsExpression="${activiti.cloud.subscription.retry.max-attempts:3}", backoff=@Backoff(delayExpression="${activiti.cloud.subscription.retry.backoff.delay:0}"))
    public void accept(SignalPayload signalPayload) {
        if (signalPayload.getVariables() == null || signalPayload.getVariables().isEmpty()) {
            this.runtimeService.signalEventReceived(signalPayload.getName());
        } else {
            this.runtimeService.signalEventReceived(signalPayload.getName(), signalPayload.getVariables());
        }
    }
}

