/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.swagger.springdoc.customizer;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Optional;
import org.activiti.cloud.common.swagger.springdoc.customizer.DefaultOpenApiCustomizer;

public class PathPrefixOpenApiCustomizer
implements DefaultOpenApiCustomizer {
    private final String swaggerBasePath;

    public PathPrefixOpenApiCustomizer(String swaggerBasePath) {
        this.swaggerBasePath = swaggerBasePath;
    }

    public void customise(OpenAPI openApi) {
        String servicePrefix = this.getServicePrefix(openApi);
        String url = (this.swaggerBasePath + servicePrefix).replaceAll("//", "/");
        this.replaceServer(openApi, url);
    }

    private String getServicePrefix(OpenAPI openApi) {
        String servicePrefix = "";
        String configuredPrefix = Optional.ofNullable(openApi.getExtensions()).map(extensions -> extensions.get("x-service-url-prefix")).orElse(null);
        if (configuredPrefix != null) {
            servicePrefix = configuredPrefix;
        }
        return servicePrefix;
    }

    private void replaceServer(OpenAPI openApi, String url) {
        ArrayList<Server> servers = new ArrayList<Server>();
        Server server = new Server();
        server.setUrl(url);
        servers.add(server);
        openApi.setServers(servers);
    }
}

