/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.swagger.springdoc.customizer;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import org.activiti.cloud.common.swagger.springdoc.customizer.DefaultOperationCustomizer;
import org.springframework.web.method.HandlerMethod;

public class ErrorResponsesOperationCustomizer
implements DefaultOperationCustomizer {
    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        ApiResponses apiResponses = operation.getResponses();
        if (!apiResponses.containsKey((Object)"401")) {
            ApiResponse unauthorizedResponse = new ApiResponse().description("Unauthorized");
            apiResponses.addApiResponse("401", unauthorizedResponse);
        }
        if (!apiResponses.containsKey((Object)"403")) {
            ApiResponse forbiddenResponse = new ApiResponse().description("Forbidden");
            apiResponses.addApiResponse("403", forbiddenResponse);
        }
        if (!apiResponses.containsKey((Object)"404")) {
            ApiResponse notFoundResponse = new ApiResponse().description("Not Found");
            apiResponses.addApiResponse("404", notFoundResponse);
        }
        return operation;
    }
}

