/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.swagger.springdoc.modelconverter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ResolvedRecursiveType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;

public abstract class InternalModelConverter<T>
implements ModelConverter {
    public Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = Json.mapper().constructType(annotatedType.getType());
        if (javaType != null && this.applies(javaType)) {
            ResolvedRecursiveType resolvedRecursiveType = this.resolveType(javaType);
            annotatedType = new AnnotatedType().type((Type)resolvedRecursiveType).ctxAnnotations(annotatedType.getCtxAnnotations()).parent(annotatedType.getParent()).schemaProperty(annotatedType.isSchemaProperty()).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).propertyName(annotatedType.getPropertyName()).skipOverride(true);
            return this.resolve(annotatedType, context, chain);
        }
        return chain.hasNext() ? chain.next().resolve(annotatedType, context, chain) : null;
    }

    protected abstract boolean applies(JavaType var1);

    protected abstract Class<T> getAlternateTypeClass();

    protected abstract JavaType getContainedType(JavaType var1);

    private ResolvedRecursiveType resolveType(JavaType javaType) {
        return new ResolvedRecursiveType(this.getAlternateTypeClass(), TypeBindings.create(this.getAlternateTypeClass(), List.of(this.getContainedType(javaType))));
    }
}

