/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starters.test.binder;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.DeclarableCustomizer;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;

@TestConfiguration
public class BinderFactoryListenerTestContext {
    private final Map<String, Queue> queues = new LinkedHashMap<String, Queue>();
    private final Map<String, Queue> anonymousQueues = new LinkedHashMap<String, Queue>();
    private final Map<String, Exchange> exchanges = new LinkedHashMap<String, Exchange>();
    private final Map<String, Binding> bindings = new LinkedHashMap<String, Binding>();

    public Map<String, Queue> getQueues() {
        return this.queues;
    }

    public Map<String, Queue> getAnonymousQueues() {
        return this.anonymousQueues;
    }

    public Map<String, Exchange> getExchanges() {
        return this.exchanges;
    }

    public Map<String, Binding> getBindings() {
        return this.bindings;
    }

    public void afterTestClass() {
        this.queues.clear();
        this.exchanges.clear();
        this.anonymousQueues.clear();
        this.bindings.clear();
    }

    @Bean
    DeclarableCustomizer binderFactoryListenerDeclarableCustomizer() {
        return declarable -> {
            if (declarable instanceof AnonymousQueue) {
                AnonymousQueue anonymousQueue = (AnonymousQueue)declarable;
                this.anonymousQueues.computeIfAbsent(anonymousQueue.getName(), key -> anonymousQueue);
            } else if (declarable instanceof Queue) {
                Queue queue = (Queue)declarable;
                this.queues.computeIfAbsent(queue.getName(), key -> queue);
            } else if (declarable instanceof Exchange) {
                Exchange exchange = (Exchange)declarable;
                this.exchanges.computeIfAbsent(exchange.getName(), key -> exchange);
            } else if (declarable instanceof Binding) {
                Binding binding = (Binding)declarable;
                this.bindings.computeIfAbsent(binding.toString(), key -> binding);
            }
            return declarable;
        };
    }
}

