/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.containers;

import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.testcontainers.containers.RabbitMQContainer;

public class RabbitMQContainerApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final RabbitMQContainer rabbitMQContainer = (RabbitMQContainer)((RabbitMQContainer)new RabbitMQContainer("rabbitmq:3.8.9-management-alpine").withReuse(true)).withExposedPorts(new Integer[]{5672, 5671, 15672, 15671});

    public void initialize(ConfigurableApplicationContext context) {
        this.initialize();
        TestPropertyValues.of((String[])RabbitMQContainerApplicationInitializer.getContainerProperties()).applyTo(context.getEnvironment());
    }

    public void initialize() {
        if (!rabbitMQContainer.isRunning()) {
            rabbitMQContainer.start();
        }
    }

    public static RabbitMQContainer getContainer() {
        return rabbitMQContainer;
    }

    public static String[] getContainerProperties() {
        return new String[]{"spring.rabbitmq.host=" + rabbitMQContainer.getContainerIpAddress(), "spring.rabbitmq.port=" + rabbitMQContainer.getAmqpPort()};
    }
}

