/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.containers;

import dasniko.testcontainers.keycloak.KeycloakContainer;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class KeycloakContainerApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static KeycloakContainer keycloakContainer = (KeycloakContainer)((KeycloakContainer)((KeycloakContainer)((KeycloakContainer)((KeycloakContainer)new KeycloakContainer("quay.io/keycloak/keycloak:24.0.3").withAdminUsername("admin")).withAdminPassword("admin")).withRealmImportFile("activiti-realm.json")).waitingFor(KeycloakContainerApplicationInitializer.legacyHealthCheckStrategy())).withReuse(true);

    @NotNull
    private static WaitStrategy legacyHealthCheckStrategy() {
        return Wait.forHttp((String)"/health/started").forPort(8080).withStartupTimeout(Duration.ofMinutes(2L));
    }

    public void initialize(ConfigurableApplicationContext context) {
        this.initialize();
        TestPropertyValues.of((String[])KeycloakContainerApplicationInitializer.getContainerProperties()).applyTo(context.getEnvironment());
    }

    public void initialize() {
        if (!keycloakContainer.isRunning()) {
            keycloakContainer.start();
        }
    }

    public static KeycloakContainer getContainer() {
        return keycloakContainer;
    }

    public static String[] getContainerProperties() {
        return new String[]{"keycloak.auth-server-url=" + KeycloakContainerApplicationInitializer.getAuthServerUrl(), "activiti.keycloak.client-id=activiti-keycloak", "activiti.keycloak.client-secret=545bc187-f10f-41f9-8d5f-cfca3dbada9c", "activiti.keycloak.grant-type=client_credentials"};
    }

    @NotNull
    private static String getAuthServerUrl() {
        String authServerUrl = keycloakContainer.getAuthServerUrl();
        if (authServerUrl.endsWith("/")) {
            return authServerUrl.substring(0, authServerUrl.length() - 1);
        }
        return authServerUrl;
    }
}

