/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.identity;

import java.util.Map;
import org.activiti.cloud.services.test.identity.IdentityTokenProducer;
import org.springframework.graphql.client.WebSocketGraphQlClientInterceptor;
import reactor.core.publisher.Mono;

public final class JwtGraphQlClientInterceptor
implements WebSocketGraphQlClientInterceptor {
    private static final String AUTHORIZATION = "Authorization";
    private final String token;

    public JwtGraphQlClientInterceptor(IdentityTokenProducer identityTokenProducer) {
        this.token = this.initToken(identityTokenProducer);
    }

    public JwtGraphQlClientInterceptor(String token) {
        this.token = "Bearer " + token;
    }

    public Mono<Object> connectionInitPayload() {
        return Mono.just(Map.of(AUTHORIZATION, this.token));
    }

    public String initToken(IdentityTokenProducer identityTokenProducer) {
        return identityTokenProducer.authorizationHeaders().getFirst(AUTHORIZATION);
    }
}

