/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.security.test.support;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.JSONArrayUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.cloud.services.common.security.test.support.RolesClaimProvider;
import org.activiti.cloud.services.common.security.test.support.WithActivitiMockUser;
import org.mockito.internal.util.collections.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.test.context.support.WithSecurityContextFactory;

public class WithActivitiMockUserSecurityContextFactory
implements WithSecurityContextFactory<WithActivitiMockUser> {
    @Autowired
    private RolesClaimProvider rolesClaimProvider;

    public SecurityContext createSecurityContext(WithActivitiMockUser annotation) {
        SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
        Set globalRoles = Sets.newSet((Object[])annotation.roles());
        Set groups = Sets.newSet((Object[])annotation.groups());
        String username = annotation.username();
        Map<String, String[]> resourceRoles = Arrays.stream(annotation.resourcesRoles()).collect(Collectors.toMap(WithActivitiMockUser.ResourceRoles::resource, WithActivitiMockUser.ResourceRoles::roles));
        Map<String, Object> claims = this.prepareClaims(globalRoles, groups, username, resourceRoles);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("testHeaderName", "testHeaderValue");
        ArrayList grantedAuthorities = new ArrayList();
        globalRoles.forEach(role -> grantedAuthorities.add(new SimpleGrantedAuthority(annotation.rolePrefix() + role)));
        byte[] secret = new Base64("Yn2kjibddFAWtnPJ2AFlL8WXmohJMCvigQggaEypa5E=").decode();
        Algorithm algorithm = Algorithm.HMAC256((byte[])secret);
        String token = JWT.create().withIssuer("Activiti Cloud").withSubject(annotation.username()).withIssuedAt(Date.from(Instant.now())).withExpiresAt(Date.from(Instant.now().plusSeconds(600L))).sign(algorithm);
        Jwt jwt = new Jwt(token, Instant.now(), Instant.now().plusSeconds(600L), headers, claims);
        JwtAuthenticationToken jwtAuthenticationToken = new JwtAuthenticationToken(jwt, grantedAuthorities);
        securityContext.setAuthentication((Authentication)jwtAuthenticationToken);
        return securityContext;
    }

    private Map<String, Object> prepareClaims(Set<String> globalRoles, Set<String> groups, String username, Map<String, String[]> resourceRoles) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("preferred_username", username);
        this.rolesClaimProvider.setGlobalRoles(globalRoles, claims);
        this.rolesClaimProvider.setResourceRoles(resourceRoles, claims);
        List groupsArray = JSONArrayUtils.newJSONArray();
        groupsArray.addAll(groups);
        claims.put("groups", groupsArray);
        claims.put("sub", username);
        return claims;
    }
}

