/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.identity.web.controller;

import java.util.Set;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractIdentityManagementControllerIT {
    public static final String HRADMIN = "hradmin";
    public static final String HRUSER = "hruser";
    public static final String USERDISABLED = "userdisabled";
    public static final String JOHNSNOW = "johnsnow";
    public static final String JSON_PATH_USERNAME = "$[0].users[?(@.username)].username";
    private MockMvc mockMvc;
    @Autowired
    private WebApplicationContext webApplicationContext;
    @Autowired
    private CacheManager cacheManager;

    @BeforeEach
    public void setUp() {
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).build();
    }

    @Test
    public void should_returnGroups_when_searchByName() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/groups?search=group", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.name)].name", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"testgroup", "salesgroup"})));
    }

    @Test
    public void should_returnUsers_when_searchByUsername() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=hr", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.username)].username", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{HRADMIN, HRUSER, USERDISABLED})));
    }

    @Test
    public void should_returnUsers_when_searchByGroup() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?group=hr", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.username)].username", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{HRADMIN, HRUSER, JOHNSNOW, USERDISABLED})));
    }

    @Test
    public void should_returnUsers_when_searchByEmail() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=hr@example.com", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)HRUSER)));
    }

    @Test
    public void should_returnUsers_when_searchByLastName() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=snow", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)JOHNSNOW)));
    }

    @Test
    public void should_returnUsers_when_searchByFirstName() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=john", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)JOHNSNOW)));
    }

    @Test
    public void should_returnOnlyUsers_when_searchByUsernameAndRoleUser() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=johnsnow&role=ACTIVITI_USER", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)JOHNSNOW)));
    }

    @Test
    public void should_returnUsers_when_searchByApplication() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?application=activiti", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)HRUSER))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[1].username", (Matcher)Matchers.is((Object)"testactivitiadmin"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[2].username", (Matcher)Matchers.is((Object)"testmanager"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[3].username", (Matcher)Matchers.is((Object)"testuser"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[4].username", (Matcher)Matchers.is((Object)USERDISABLED)));
    }

    @Test
    public void should_notReturnUsers_when_searchByInvalidApplication() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?application=activitis", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void should_returnUsers_when_searchByUsernameAndApplication() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=hruser&application=activiti", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)HRUSER)));
    }

    @Test
    public void should_returnUsers_when_searchByGroupAndApplication() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?group=hr&application=activiti", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)HRUSER))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[1].username", (Matcher)Matchers.is((Object)USERDISABLED)));
    }

    @Test
    public void should_returnUsers_when_searchByRoleAndApplication() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?role=ACTIVITI_ADMIN&application=activiti", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)"testactivitiadmin")));
    }

    @Test
    public void should_returnOnlyAdmins_when_searchByUsernameAndRoleAdmin() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=hr&role=ACTIVITI_ADMIN", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)HRADMIN)));
    }

    @Test
    public void should_returnOnlyAdmins_when_searchByRoleAdmin() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?role=ACTIVITI_ADMIN", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].username", (Matcher)Matchers.is((Object)"admin"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[1].username", (Matcher)Matchers.is((Object)HRADMIN))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[2].username", (Matcher)Matchers.is((Object)"testactivitiadmin"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[3].username", (Matcher)Matchers.is((Object)"testadmin")));
    }

    @Test
    public void should_returnGroups_when_searchByNameAndRole() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/groups?search=group&role=ACTIVITI_USER", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].name", (Matcher)Matchers.is((Object)"salesgroup")));
    }

    @Test
    public void should_returnGroups_when_searchByRole() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/groups?role=ACTIVITI_USER", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].name", (Matcher)Matchers.is((Object)"hr"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[1].name", (Matcher)Matchers.is((Object)"salesgroup")));
    }

    @Test
    public void should_returnGroups_when_searchByApplication() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/groups?application=activiti", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.name)].name", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"salesgroup", "dynamic"})));
    }

    @Test
    public void should_notReturnGroups_when_searchByInvalidApplication() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/groups?application=fake", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void should_returnStatusOk_when_addingAppPermissions() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/v1/permissions/{application}", (Object[])new Object[]{"test-client"}).contentType(MediaType.APPLICATION_JSON).content("[\n    {\"role\":\"ACTIVITI_ADMIN\",\n    \"users\":[\"hradmin\"],\n    \"groups\":[]}\n  ]")).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void should_returnNotFound_when_addingAppPermissionsToInvalidApplication() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/v1/permissions/{application}", (Object[])new Object[]{"fakeApp"}).contentType(MediaType.APPLICATION_JSON).content("[\n    {\"role\":\"ACTIVITI_ADMIN\",\n    \"users\":[\"hradmin\"],\n    \"groups\":[]}\n  ]")).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.status().reason("Invalid Security data: application {fakeApp} is invalid or doesn't exist"));
    }

    @Test
    public void should_returnBadRequest_when_addingAppPermissionsWithInvalidRole() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/v1/permissions/{application}", (Object[])new Object[]{"test-client"}).contentType(MediaType.APPLICATION_JSON).content("[\n    {\"role\":\"fakeRole\",\n    \"users\":[\"testUser\"],\n    \"groups\":[]}\n  ]")).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.status().reason("Invalid Security data: role {fakeRole} is invalid or doesn't exist"));
    }

    @Test
    public void should_returnBadRequest_when_addingAppPermissionsWithInvalidUserRole() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/v1/permissions/{application}", (Object[])new Object[]{"test-client"}).contentType(MediaType.APPLICATION_JSON).content("[\n    {\"role\":\"ACTIVITI_ADMIN\",\n    \"users\":[\"hruser\"],\n    \"groups\":[]}\n  ]")).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.status().reason("Invalid Security data: role {ACTIVITI_ADMIN} can't be assigned to user {hruser}"));
    }

    @Test
    public void should_returnBadRequest_when_addingAppPermissionsWithInvalidGroup() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/v1/permissions/{application}", (Object[])new Object[]{"test-client"}).contentType(MediaType.APPLICATION_JSON).content("[\n    {\"role\":\"ACTIVITI_ADMIN\",\n    \"users\":[\"testadmin\"],\n    \"groups\":[\"fakeGroup\"]}\n  ]")).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.status().reason("Invalid Security data: group {fakeGroup} is invalid or doesn't exist"));
    }

    @Test
    public void should_returnBadRequest_when_addingAppPermissionsWithInvalidGroupRole() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/v1/permissions/{application}", (Object[])new Object[]{"test-client"}).contentType(MediaType.APPLICATION_JSON).content("[\n    {\"role\":\"ACTIVITI_ADMIN\",\n    \"users\":[\"testadmin\"],\n    \"groups\":[\"hr\"]}\n  ]")).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.status().reason("Invalid Security data: role {ACTIVITI_ADMIN} can't be assigned to group {hr}"));
    }

    @Test
    public void should_returnApplicationPermissions_when_filteringByRole() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/permissions/{application}?role={role}", (Object[])new Object[]{"activiti", "ACTIVITI_USER"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].role", (Matcher)Matchers.is((Object)"ACTIVITI_USER"))).andExpect(MockMvcResultMatchers.jsonPath((String)JSON_PATH_USERNAME, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{HRUSER, "testuser", USERDISABLED}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[0].groups[?(@.name)].name", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"salesgroup"})));
    }

    @Test
    public void should_returnApplicationPermissions() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/permissions/{application}", (Object[])new Object[]{"activiti"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.role)].role", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"ACTIVITI_USER", "ACTIVITI_ADMIN", "APPLICATION_MANAGER", "uma_authorization", "offline_access", "DYNAMIC_ROLE"})));
    }

    @Test
    public void should_notReturnApplicationPermissions_when_roleIsInvalid() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/permissions/{application}?role={role}", (Object[])new Object[]{"activiti", "role"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void should_returnGroups_when_searchByNameWithCache() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/groups?search=search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/groups?search=search&role=role", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/groups?role=role", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        Cache cache = this.cacheManager.getCache("groupSearch");
        Assertions.assertThat((Object)cache.get(SimpleKeyGenerator.generateKey((Object[])new Object[]{"search", null, null}))).isNotNull();
        Assertions.assertThat((Object)cache.get(SimpleKeyGenerator.generateKey((Object[])new Object[]{"search", Set.of("role"), null}))).isNotNull();
        Assertions.assertThat((Object)cache.get(SimpleKeyGenerator.generateKey((Object[])new Object[]{null, Set.of("role"), null}))).isNotNull();
    }

    @Test
    public void should_returnUsers_when_searchByLastNameCache() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=search&group=group", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=search&role=role", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=search&role=role&group=group", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=search&type=INTERACTIVE", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        Cache cache = this.cacheManager.getCache("userSearch");
        if (cache != null) {
            Assertions.assertThat((Object)cache.get(SimpleKeyGenerator.generateKey((Object[])new Object[]{"search", null, null, null, null, null}))).isNotNull();
            Assertions.assertThat((Object)cache.get(SimpleKeyGenerator.generateKey((Object[])new Object[]{"search", Set.of("role"), null, null, null, null}))).isNotNull();
            Assertions.assertThat((Object)cache.get(SimpleKeyGenerator.generateKey((Object[])new Object[]{"search", Set.of("role"), Set.of("group"), null, null, null}))).isNotNull();
            Assertions.assertThat((Object)cache.get(SimpleKeyGenerator.generateKey((Object[])new Object[]{"search", null, Set.of("group"), null, null, null}))).isNotNull();
            Assertions.assertThat((Object)cache.get(SimpleKeyGenerator.generateKey((Object[])new Object[]{"search", null, null, "INTERACTIVE", null, null}))).isNotNull();
        }
    }

    @Test
    public void should_returnBadRequest_whenWrongUserTypeIsPassed() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=search&type=WRONG", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void should_returnDeactivatedUsers_whenNotSpecified() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=hr", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.username)].username", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{HRADMIN, HRUSER, USERDISABLED})));
    }

    @Test
    public void should_filterDeactivatedUsers_whenSpecifiedTrue() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=hr&hideDeactivatedUser=true", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.username)].username", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{HRADMIN, HRUSER})));
    }

    @Test
    public void should_returnDeactivatedUsers_whenSpecifiedFalse() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/v1/users?search=hr&hideDeactivatedUser=false", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.username)].username", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{HRADMIN, HRUSER, USERDISABLED})));
    }
}

